/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.mqtt.handler;

import cn.hutool.core.text.CharSequenceUtil;
import io.github.pnoker.common.mqtt.entity.MessageHeader;
import io.github.pnoker.common.mqtt.entity.MqttMessage;
import io.github.pnoker.common.mqtt.service.MqttReceiveService;
import io.github.pnoker.common.mqtt.service.job.MqttScheduleJob;
import jakarta.annotation.Resource;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.messaging.MessageHandler;
import org.springframework.stereotype.Component;

@Component
public class MqttReceiveHandler {
    private static final Logger log = LoggerFactory.getLogger(MqttReceiveHandler.class);
    @Value(value="${driver.mqtt.batch.speed}")
    private Integer batchSpeed;
    @Resource
    private MqttReceiveService mqttReceiveService;
    @Resource
    private ThreadPoolExecutor threadPoolExecutor;

    @Bean
    @ServiceActivator(inputChannel="mqttInboundChannel")
    public MessageHandler mqttInboundReceive() {
        return message -> {
            try {
                MessageHeader messageHeader = new MessageHeader(message.getHeaders());
                String payload = message.getPayload().toString();
                if (CharSequenceUtil.isEmpty((CharSequence)payload)) {
                    log.error("Invalid mqtt inbound, From: {}, Qos: {}, Payload: null", (Object)messageHeader.getMqttReceivedTopic(), (Object)messageHeader.getMqttReceivedQos());
                    return;
                }
                MqttScheduleJob.messageCount.getAndIncrement();
                MqttMessage mqttMessage = MqttMessage.builder().header(messageHeader).payload(payload).build();
                log.debug("Mqtt inbound, From: {}, Qos: {}, Payload: {}", new Object[]{messageHeader.getMqttReceivedTopic(), messageHeader.getMqttReceivedQos(), payload});
                if (MqttScheduleJob.messageSpeed.get() < (long)this.batchSpeed.intValue()) {
                    this.threadPoolExecutor.execute(() -> this.mqttReceiveService.receiveValue(mqttMessage));
                } else {
                    MqttScheduleJob.messageLock.writeLock().lock();
                    MqttScheduleJob.addMqttMessages(mqttMessage);
                    MqttScheduleJob.messageLock.writeLock().unlock();
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        };
    }
}

