/*
 * Decompiled with CFR 0.152.
 */
package com.ttk.agg.openapi.sdk.dto;

import com.ttk.agg.openapi.sdk.dto.ExceptionResult;

public class CallResult<T> {
    private final boolean success;
    private final ExceptionResult exceptionResult;
    private final T data;

    public CallResult(boolean success, ExceptionResult exceptionResult, T data) {
        this.success = success;
        this.exceptionResult = exceptionResult;
        this.data = data;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public ExceptionResult getExceptionResult() {
        return this.exceptionResult;
    }

    public T getData() {
        return this.data;
    }

    public static <T> CallResult<T> success() {
        return new CallResult<Object>(true, null, null);
    }

    public static <T> CallResult<T> success(T data) {
        return new CallResult<T>(true, null, data);
    }

    public static <T> CallResult<T> fail(ExceptionResult exceptionResult) {
        return new CallResult<Object>(false, exceptionResult, null);
    }

    public String toString() {
        return "CallResult(success=" + this.isSuccess() + ", exceptionResult=" + this.getExceptionResult() + ", data=" + this.getData() + ")";
    }
}

