/*
 * Decompiled with CFR 0.152.
 */
package io.github.rctcwyvrn.blake3;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class Blake3 {
    private static final char[] HEX_ARRAY = "0123456789abcdef".toCharArray();
    private static final int DEFAULT_HASH_LEN = 32;
    private static final int OUT_LEN = 32;
    private static final int KEY_LEN = 32;
    private static final int BLOCK_LEN = 64;
    private static final int CHUNK_LEN = 1024;
    private static final int CHUNK_START = 1;
    private static final int CHUNK_END = 2;
    private static final int PARENT = 4;
    private static final int ROOT = 8;
    private static final int KEYED_HASH = 16;
    private static final int DERIVE_KEY_CONTEXT = 32;
    private static final int DERIVE_KEY_MATERIAL = 64;
    private static final int[] IV = new int[]{1779033703, -1150833019, 1013904242, -1521486534, 1359893119, -1694144372, 528734635, 1541459225};
    private static final int[] MSG_PERMUTATION = new int[]{2, 6, 3, 10, 7, 0, 4, 13, 1, 11, 12, 5, 9, 14, 15, 8};
    private ChunkState chunkState;
    private int[] key;
    private final int[][] cvStack = new int[54][];
    private byte cvStackLen = 0;
    private int flags;

    private static int wrappingAdd(int a, int b) {
        return a + b;
    }

    private static int rotateRight(int x, int len) {
        return x >>> len | x << 32 - len;
    }

    private static void g(int[] state, int a, int b, int c, int d, int mx, int my) {
        state[a] = Blake3.wrappingAdd(Blake3.wrappingAdd(state[a], state[b]), mx);
        state[d] = Blake3.rotateRight(state[d] ^ state[a], 16);
        state[c] = Blake3.wrappingAdd(state[c], state[d]);
        state[b] = Blake3.rotateRight(state[b] ^ state[c], 12);
        state[a] = Blake3.wrappingAdd(Blake3.wrappingAdd(state[a], state[b]), my);
        state[d] = Blake3.rotateRight(state[d] ^ state[a], 8);
        state[c] = Blake3.wrappingAdd(state[c], state[d]);
        state[b] = Blake3.rotateRight(state[b] ^ state[c], 7);
    }

    private static void roundFn(int[] state, int[] m) {
        Blake3.g(state, 0, 4, 8, 12, m[0], m[1]);
        Blake3.g(state, 1, 5, 9, 13, m[2], m[3]);
        Blake3.g(state, 2, 6, 10, 14, m[4], m[5]);
        Blake3.g(state, 3, 7, 11, 15, m[6], m[7]);
        Blake3.g(state, 0, 5, 10, 15, m[8], m[9]);
        Blake3.g(state, 1, 6, 11, 12, m[10], m[11]);
        Blake3.g(state, 2, 7, 8, 13, m[12], m[13]);
        Blake3.g(state, 3, 4, 9, 14, m[14], m[15]);
    }

    private static int[] permute(int[] m) {
        int[] permuted = new int[16];
        for (int i = 0; i < 16; ++i) {
            permuted[i] = m[MSG_PERMUTATION[i]];
        }
        return permuted;
    }

    private static int[] compress(int[] chainingValue, int[] blockWords, long counter, int blockLen, int flags) {
        int counterInt = (int)(counter & 0xFFFFFFFFL);
        int counterShift = (int)(counter >> 32 & 0xFFFFFFFFL);
        int[] state = new int[]{chainingValue[0], chainingValue[1], chainingValue[2], chainingValue[3], chainingValue[4], chainingValue[5], chainingValue[6], chainingValue[7], IV[0], IV[1], IV[2], IV[3], counterInt, counterShift, blockLen, flags};
        Blake3.roundFn(state, blockWords);
        blockWords = Blake3.permute(blockWords);
        Blake3.roundFn(state, blockWords);
        blockWords = Blake3.permute(blockWords);
        Blake3.roundFn(state, blockWords);
        blockWords = Blake3.permute(blockWords);
        Blake3.roundFn(state, blockWords);
        blockWords = Blake3.permute(blockWords);
        Blake3.roundFn(state, blockWords);
        blockWords = Blake3.permute(blockWords);
        Blake3.roundFn(state, blockWords);
        blockWords = Blake3.permute(blockWords);
        Blake3.roundFn(state, blockWords);
        for (int i = 0; i < 8; ++i) {
            int n = i;
            state[n] = state[n] ^ state[i + 8];
            int n2 = i + 8;
            state[n2] = state[n2] ^ chainingValue[i];
        }
        return state;
    }

    private static int[] wordsFromLEBytes(byte[] bytes) {
        int[] words = new int[bytes.length / 4];
        ByteBuffer buf = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; i < words.length; ++i) {
            words[i] = buf.getInt();
        }
        return words;
    }

    private Blake3() {
        this.initialize(IV, 0);
    }

    private Blake3(byte[] key) {
        this.initialize(Blake3.wordsFromLEBytes(key), 16);
    }

    private Blake3(String context) {
        Blake3 contextHasher = new Blake3();
        contextHasher.initialize(IV, 32);
        contextHasher.update(context.getBytes(StandardCharsets.UTF_8));
        int[] contextKey = Blake3.wordsFromLEBytes(contextHasher.digest());
        this.initialize(contextKey, 64);
    }

    private void initialize(int[] key, int flags) {
        this.chunkState = new ChunkState(key, 0L, flags);
        this.key = key;
        this.flags = flags;
    }

    public void update(File file) throws IOException {
        try (FileInputStream ios = new FileInputStream(file);){
            byte[] buffer = new byte[4096];
            int read = 0;
            while ((read = ((InputStream)ios).read(buffer)) != -1) {
                if (read == buffer.length) {
                    this.update(buffer);
                    continue;
                }
                this.update(Arrays.copyOfRange(buffer, 0, read));
            }
        }
    }

    public void update(byte[] input) {
        int take;
        for (int currPos = 0; currPos < input.length; currPos += take) {
            if (this.chunkState.len() == 1024) {
                int[] chunkCV = this.chunkState.createNode().chainingValue();
                long totalChunks = this.chunkState.chunkCounter + 1L;
                this.addChunkChainingValue(chunkCV, totalChunks);
                this.chunkState = new ChunkState(this.key, totalChunks, this.flags);
            }
            int want = 1024 - this.chunkState.len();
            take = Math.min(want, input.length - currPos);
            this.chunkState.update(Arrays.copyOfRange(input, currPos, currPos + take));
        }
    }

    public byte[] digest(int hashLen) {
        Node node = this.chunkState.createNode();
        int parentNodesRemaining = this.cvStackLen;
        while (parentNodesRemaining > 0) {
            node = Blake3.parentNode(this.cvStack[--parentNodesRemaining], node.chainingValue(), this.key, this.flags);
        }
        return node.rootOutputBytes(hashLen);
    }

    public byte[] digest() {
        return this.digest(32);
    }

    public String hexdigest(int hashLen) {
        return Blake3.bytesToHex(this.digest(hashLen));
    }

    public String hexdigest() {
        return this.hexdigest(32);
    }

    private void pushStack(int[] cv) {
        this.cvStack[this.cvStackLen] = cv;
        this.cvStackLen = (byte)(this.cvStackLen + 1);
    }

    private int[] popStack() {
        this.cvStackLen = (byte)(this.cvStackLen - 1);
        return this.cvStack[this.cvStackLen];
    }

    private static Node parentNode(int[] leftChildCV, int[] rightChildCV, int[] key, int flags) {
        int x;
        int n;
        int[] blockWords = new int[16];
        int i = 0;
        int[] nArray = leftChildCV;
        int n2 = nArray.length;
        for (n = 0; n < n2; ++n) {
            blockWords[i] = x = nArray[n];
            ++i;
        }
        nArray = rightChildCV;
        n2 = nArray.length;
        for (n = 0; n < n2; ++n) {
            blockWords[i] = x = nArray[n];
            ++i;
        }
        return new Node(key, blockWords, 0L, 64, 4 | flags);
    }

    private static int[] parentCV(int[] leftChildCV, int[] rightChildCV, int[] key, int flags) {
        return Blake3.parentNode(leftChildCV, rightChildCV, key, flags).chainingValue();
    }

    private void addChunkChainingValue(int[] newCV, long totalChunks) {
        while ((totalChunks & 1L) == 0L) {
            newCV = Blake3.parentCV(this.popStack(), newCV, this.key, this.flags);
            totalChunks >>= 1;
        }
        this.pushStack(newCV);
    }

    private static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    public static Blake3 newInstance() {
        return new Blake3();
    }

    public static Blake3 newKeyedHasher(byte[] key) {
        if (key.length != 32) {
            throw new IllegalStateException("Invalid key length");
        }
        return new Blake3(key);
    }

    public static Blake3 newKeyDerivationHasher(String context) {
        return new Blake3(context);
    }

    private static class ChunkState {
        int[] chainingValue;
        long chunkCounter;
        byte[] block = new byte[64];
        byte blockLen = 0;
        byte blocksCompressed = 0;
        int flags;

        public ChunkState(int[] key, long chunkCounter, int flags) {
            this.chainingValue = key;
            this.chunkCounter = chunkCounter;
            this.flags = flags;
        }

        public int len() {
            return 64 * this.blocksCompressed + this.blockLen;
        }

        private int startFlag() {
            return this.blocksCompressed == 0 ? 1 : 0;
        }

        private void update(byte[] input) {
            int canTake;
            for (int currPos = 0; currPos < input.length; currPos += canTake) {
                if (this.blockLen == 64) {
                    int[] blockWords = Blake3.wordsFromLEBytes(this.block);
                    this.chainingValue = Arrays.copyOfRange(Blake3.compress(this.chainingValue, blockWords, this.chunkCounter, 64, this.flags | this.startFlag()), 0, 8);
                    this.blocksCompressed = (byte)(this.blocksCompressed + 1);
                    this.block = new byte[64];
                    this.blockLen = 0;
                }
                int want = 64 - this.blockLen;
                canTake = Math.min(want, input.length - currPos);
                System.arraycopy(input, currPos, this.block, this.blockLen, canTake);
                this.blockLen = (byte)(this.blockLen + canTake);
            }
        }

        private Node createNode() {
            return new Node(this.chainingValue, Blake3.wordsFromLEBytes(this.block), this.chunkCounter, this.blockLen, this.flags | this.startFlag() | 2);
        }
    }

    private static class Node {
        int[] inputChainingValue;
        int[] blockWords;
        long counter;
        int blockLen;
        int flags;

        private Node(int[] inputChainingValue, int[] blockWords, long counter, int blockLen, int flags) {
            this.inputChainingValue = inputChainingValue;
            this.blockWords = blockWords;
            this.counter = counter;
            this.blockLen = blockLen;
            this.flags = flags;
        }

        private int[] chainingValue() {
            return Arrays.copyOfRange(Blake3.compress(this.inputChainingValue, this.blockWords, this.counter, this.blockLen, this.flags), 0, 8);
        }

        private byte[] rootOutputBytes(int outLen) {
            int outputsNeeded = Math.floorDiv(outLen, 64) + 1;
            byte[] hash = new byte[outLen];
            int i = 0;
            for (int outputCounter = 0; outputCounter < outputsNeeded; ++outputCounter) {
                int[] words;
                for (int word : words = Blake3.compress(this.inputChainingValue, this.blockWords, outputCounter, this.blockLen, this.flags | 8)) {
                    byte[] byArray = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(word).array();
                    int n = byArray.length;
                    for (int j = 0; j < n; ++j) {
                        byte b;
                        hash[i] = b = byArray[j];
                        if (++i != outLen) continue;
                        return hash;
                    }
                }
            }
            throw new IllegalStateException("Uh oh something has gone horribly wrong. Please create an issue on https://github.com/rctcwyvrn/blake3");
        }
    }
}

