/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.retry;

import io.github.resilience4j.core.EventConsumer;
import io.github.resilience4j.retry.RetryConfig;
import io.github.resilience4j.retry.event.RetryEvent;
import io.github.resilience4j.retry.event.RetryOnErrorEvent;
import io.github.resilience4j.retry.event.RetryOnIgnoredErrorEvent;
import io.github.resilience4j.retry.event.RetryOnRetryEvent;
import io.github.resilience4j.retry.event.RetryOnSuccessEvent;
import io.github.resilience4j.retry.internal.RetryImpl;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.CheckedRunnable;
import java.io.Serializable;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;

public interface Retry {
    public static Retry of(String name, RetryConfig retryConfig) {
        return new RetryImpl(name, retryConfig);
    }

    public static Retry of(String name, Supplier<RetryConfig> retryConfigSupplier) {
        return new RetryImpl(name, retryConfigSupplier.get());
    }

    public static Retry ofDefaults(String name) {
        return new RetryImpl(name, RetryConfig.ofDefaults());
    }

    public static <T> Supplier<CompletionStage<T>> decorateCompletionStage(Retry retry, ScheduledExecutorService scheduler, Supplier<CompletionStage<T>> supplier) {
        return () -> {
            CompletableFuture promise = new CompletableFuture();
            AsyncRetryBlock block = new AsyncRetryBlock(scheduler, retry.asyncContext(), supplier, promise);
            block.run();
            return promise;
        };
    }

    public static <T> CheckedFunction0<T> decorateCheckedSupplier(Retry retry, CheckedFunction0<T> supplier) {
        return (CheckedFunction0 & Serializable)() -> {
            Context<Object> context = retry.context();
            while (true) {
                try {
                    Object result;
                    boolean validationOfResult;
                    while (validationOfResult = context.onResult(result = supplier.apply())) {
                    }
                    context.onSuccess();
                    return result;
                }
                catch (Exception exception) {
                    context.onError(exception);
                    continue;
                }
                break;
            }
        };
    }

    public static CheckedRunnable decorateCheckedRunnable(Retry retry, CheckedRunnable runnable) {
        return () -> {
            Context context = retry.context();
            while (true) {
                try {
                    runnable.run();
                    context.onSuccess();
                }
                catch (Exception exception) {
                    context.onError(exception);
                    continue;
                }
                break;
            }
        };
    }

    public static <T, R> CheckedFunction1<T, R> decorateCheckedFunction(Retry retry, CheckedFunction1<T, R> function) {
        return (CheckedFunction1 & Serializable)t -> {
            Context<Object> context = retry.context();
            while (true) {
                try {
                    Object result;
                    boolean validationOfResult;
                    while (validationOfResult = context.onResult(result = function.apply(t))) {
                    }
                    context.onSuccess();
                    return result;
                }
                catch (Exception exception) {
                    context.onError(exception);
                    continue;
                }
                break;
            }
        };
    }

    public static <T> Supplier<T> decorateSupplier(Retry retry, Supplier<T> supplier) {
        return () -> {
            Context context = retry.context();
            while (true) {
                try {
                    Object result;
                    boolean validationOfResult;
                    while (validationOfResult = context.onResult(result = supplier.get())) {
                    }
                    context.onSuccess();
                    return result;
                }
                catch (RuntimeException runtimeException) {
                    context.onRuntimeError(runtimeException);
                    continue;
                }
                break;
            }
        };
    }

    public static <T> Callable<T> decorateCallable(Retry retry, Callable<T> supplier) {
        return () -> {
            Context context = retry.context();
            while (true) {
                try {
                    Object result;
                    boolean validationOfResult;
                    while (validationOfResult = context.onResult(result = supplier.call())) {
                    }
                    context.onSuccess();
                    return result;
                }
                catch (Exception exception) {
                    context.onError(exception);
                    continue;
                }
                break;
            }
        };
    }

    public static Runnable decorateRunnable(Retry retry, Runnable runnable) {
        return () -> {
            Context context = retry.context();
            while (true) {
                try {
                    runnable.run();
                    context.onSuccess();
                }
                catch (RuntimeException runtimeException) {
                    context.onRuntimeError(runtimeException);
                    continue;
                }
                break;
            }
        };
    }

    public static <T, R> Function<T, R> decorateFunction(Retry retry, Function<T, R> function) {
        return t -> {
            Context context = retry.context();
            while (true) {
                try {
                    Object result;
                    boolean validationOfResult;
                    while (validationOfResult = context.onResult(result = function.apply(t))) {
                    }
                    context.onSuccess();
                    return result;
                }
                catch (RuntimeException runtimeException) {
                    context.onRuntimeError(runtimeException);
                    continue;
                }
                break;
            }
        };
    }

    public String getName();

    public <T> Context<T> context();

    public <T> AsyncContext<T> asyncContext();

    public RetryConfig getRetryConfig();

    public EventPublisher getEventPublisher();

    default public <T> T executeCheckedSupplier(CheckedFunction0<T> checkedSupplier) throws Throwable {
        return (T)Retry.decorateCheckedSupplier(this, checkedSupplier).apply();
    }

    default public <T> T executeSupplier(Supplier<T> supplier) {
        return Retry.decorateSupplier(this, supplier).get();
    }

    default public <T> T executeCallable(Callable<T> callable) throws Exception {
        return Retry.decorateCallable(this, callable).call();
    }

    default public void executeRunnable(Runnable runnable) {
        Retry.decorateRunnable(this, runnable).run();
    }

    default public <T> CompletionStage<T> executeCompletionStage(ScheduledExecutorService scheduler, Supplier<CompletionStage<T>> supplier) {
        return Retry.decorateCompletionStage(this, scheduler, supplier).get();
    }

    public Metrics getMetrics();

    public static class AsyncRetryBlock<T>
    implements Runnable {
        private final ScheduledExecutorService scheduler;
        private final AsyncContext<T> retryContext;
        private final Supplier<CompletionStage<T>> supplier;
        private final CompletableFuture<T> promise;

        AsyncRetryBlock(ScheduledExecutorService scheduler, AsyncContext<T> retryContext, Supplier<CompletionStage<T>> supplier, CompletableFuture<T> promise) {
            this.scheduler = scheduler;
            this.retryContext = retryContext;
            this.supplier = supplier;
            this.promise = promise;
        }

        @Override
        public void run() {
            CompletionStage<Object> stage = this.supplier.get();
            stage.whenComplete((result, t) -> {
                if (result != null) {
                    this.onResult(result);
                } else if (t instanceof Exception) {
                    this.onError((Exception)t);
                } else {
                    this.promise.completeExceptionally((Throwable)t);
                }
            });
        }

        private void onError(Exception t) {
            long delay = this.retryContext.onError(t);
            if (delay < 1L) {
                this.promise.completeExceptionally(t);
            } else {
                this.scheduler.schedule(this, delay, TimeUnit.MILLISECONDS);
            }
        }

        private void onResult(T result) {
            long delay = this.retryContext.onResult(result);
            if (delay < 1L) {
                this.promise.complete(result);
                this.retryContext.onSuccess();
            } else {
                this.scheduler.schedule(this, delay, TimeUnit.MILLISECONDS);
            }
        }
    }

    public static interface EventPublisher
    extends io.github.resilience4j.core.EventPublisher<RetryEvent> {
        public EventPublisher onRetry(EventConsumer<RetryOnRetryEvent> var1);

        public EventPublisher onSuccess(EventConsumer<RetryOnSuccessEvent> var1);

        public EventPublisher onError(EventConsumer<RetryOnErrorEvent> var1);

        public EventPublisher onIgnoredError(EventConsumer<RetryOnIgnoredErrorEvent> var1);
    }

    public static interface Context<T> {
        public void onSuccess();

        public boolean onResult(T var1);

        public void onError(Exception var1) throws Exception;

        public void onRuntimeError(RuntimeException var1);
    }

    public static interface AsyncContext<T> {
        public void onSuccess();

        public long onError(Throwable var1);

        public long onResult(T var1);
    }

    public static interface Metrics {
        public long getNumberOfSuccessfulCallsWithoutRetryAttempt();

        public long getNumberOfFailedCallsWithoutRetryAttempt();

        public long getNumberOfSuccessfulCallsWithRetryAttempt();

        public long getNumberOfFailedCallsWithRetryAttempt();
    }
}

