/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.bulkhead.configure;

import io.github.resilience4j.bulkhead.BulkheadConfig;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.Min;

public class BulkheadConfigurationProperties {
    private int bulkheadAspectOrder = 0x7FFFFFFD;
    private Map<String, BackendProperties> backends = new HashMap<String, BackendProperties>();

    public int getBulkheadAspectOrder() {
        return this.bulkheadAspectOrder;
    }

    public void setBulkheadAspectOrder(int bulkheadAspectOrder) {
        this.bulkheadAspectOrder = bulkheadAspectOrder;
    }

    private BackendProperties getBackendProperties(String backend) {
        return this.backends.get(backend);
    }

    public BulkheadConfig createBulkheadConfig(String backend) {
        return this.createBulkheadConfig(this.getBackendProperties(backend));
    }

    private BulkheadConfig createBulkheadConfig(BackendProperties backendProperties) {
        return this.buildBulkheadConfig(backendProperties).build();
    }

    public BulkheadConfig.Builder buildBulkheadConfig(BackendProperties properties) {
        if (properties == null) {
            return new BulkheadConfig.Builder();
        }
        BulkheadConfig.Builder builder = BulkheadConfig.custom();
        if (properties.getMaxConcurrentCall() != null) {
            builder.maxConcurrentCalls(properties.getMaxConcurrentCall().intValue());
        }
        if (properties.getMaxWaitTime() != null) {
            builder.maxWaitTime(properties.getMaxWaitTime().longValue());
        }
        return builder;
    }

    public Map<String, BackendProperties> getBackends() {
        return this.backends;
    }

    public static class BackendProperties {
        @Min(value=1L)
        private @Min(value=1L) Integer maxConcurrentCall;
        @Min(value=0L)
        private @Min(value=0L) Long maxWaitTime;
        @Min(value=1L)
        private @Min(value=1L) Integer eventConsumerBufferSize = 100;

        public Integer getMaxConcurrentCall() {
            return this.maxConcurrentCall;
        }

        public void setMaxConcurrentCall(Integer maxConcurrentCall) {
            this.maxConcurrentCall = maxConcurrentCall;
        }

        public Long getMaxWaitTime() {
            return this.maxWaitTime;
        }

        public void setMaxWaitTime(Long maxWaitTime) {
            this.maxWaitTime = maxWaitTime;
        }

        public Integer getEventConsumerBufferSize() {
            return this.eventConsumerBufferSize;
        }

        public void setEventConsumerBufferSize(Integer eventConsumerBufferSize) {
            this.eventConsumerBufferSize = eventConsumerBufferSize;
        }
    }
}

