/*
 *
 *  Copyright 2019 authors
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 *
 */
package io.github.resilience4j.timelimiter.internal;


import io.github.resilience4j.core.EventConsumer;
import io.github.resilience4j.core.EventProcessor;
import io.github.resilience4j.timelimiter.TimeLimiter;
import io.github.resilience4j.timelimiter.event.TimeLimiterEvent;
import io.github.resilience4j.timelimiter.event.TimeLimiterOnErrorEvent;
import io.github.resilience4j.timelimiter.event.TimeLimiterOnSuccessEvent;
import io.github.resilience4j.timelimiter.event.TimeLimiterOnTimeoutEvent;

public class TimeLimiterEventProcessor extends EventProcessor<TimeLimiterEvent> implements
    EventConsumer<TimeLimiterEvent>, TimeLimiter.EventPublisher {

    @Override
    public void consumeEvent(TimeLimiterEvent event) {
        super.processEvent(event);
    }

    @Override
    public TimeLimiter.EventPublisher onSuccess(
        EventConsumer<TimeLimiterOnSuccessEvent> onSuccessEventConsumer) {
        registerConsumer(TimeLimiterOnSuccessEvent.class.getName(), onSuccessEventConsumer);
        return this;
    }

    @Override
    public TimeLimiter.EventPublisher onError(
        EventConsumer<TimeLimiterOnErrorEvent> onOnFailureEventConsumer) {
        registerConsumer(TimeLimiterOnErrorEvent.class.getName(), onOnFailureEventConsumer);
        return this;
    }

    @Override
    public TimeLimiter.EventPublisher onTimeout(
        EventConsumer<TimeLimiterOnTimeoutEvent> onOnFailureEventConsumer) {
        registerConsumer(TimeLimiterOnTimeoutEvent.class.getName(), onOnFailureEventConsumer);
        return this;
    }
}