/*
 * Decompiled with CFR 0.152.
 */
package io.github.robwin.swagger2markup.builder.document;

import io.github.robwin.swagger2markup.builder.document.MarkupDocument;
import io.github.robwin.swagger2markup.config.Swagger2MarkupConfig;
import io.swagger.models.Contact;
import io.swagger.models.Info;
import io.swagger.models.License;
import io.swagger.models.Scheme;
import io.swagger.models.Tag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ResourceBundle;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class OverviewDocument
extends MarkupDocument {
    private final String OVERVIEW;
    private final String CURRENT_VERSION;
    private final String VERSION;
    private final String CONTACT_INFORMATION;
    private final String CONTACT_NAME;
    private final String CONTACT_EMAIL;
    private final String LICENSE_INFORMATION;
    private final String LICENSE;
    private final String LICENSE_URL;
    private final String TERMS_OF_SERVICE;
    private final String URI_SCHEME;
    private final String HOST;
    private final String BASE_PATH;
    private final String SCHEMES;

    public OverviewDocument(Swagger2MarkupConfig swagger2MarkupConfig) {
        super(swagger2MarkupConfig);
        ResourceBundle labels = ResourceBundle.getBundle("lang/labels", swagger2MarkupConfig.getOutputLanguage().toLocale());
        this.OVERVIEW = labels.getString("overview");
        this.CURRENT_VERSION = labels.getString("current_version");
        this.VERSION = labels.getString("version");
        this.CONTACT_INFORMATION = labels.getString("contact_information");
        this.CONTACT_NAME = labels.getString("contact_name");
        this.CONTACT_EMAIL = labels.getString("contact_email");
        this.LICENSE_INFORMATION = labels.getString("license_information");
        this.LICENSE = labels.getString("license");
        this.LICENSE_URL = labels.getString("license_url");
        this.TERMS_OF_SERVICE = labels.getString("terms_of_service");
        this.URI_SCHEME = labels.getString("uri_scheme");
        this.HOST = labels.getString("host");
        this.BASE_PATH = labels.getString("base_path");
        this.SCHEMES = labels.getString("schemes");
    }

    @Override
    public MarkupDocument build() {
        this.overview();
        return this;
    }

    private void overview() {
        License license;
        Contact contact;
        Info info = this.swagger.getInfo();
        this.markupDocBuilder.documentTitle(info.getTitle());
        this.markupDocBuilder.sectionTitleLevel1(this.OVERVIEW);
        if (StringUtils.isNotBlank((CharSequence)info.getDescription())) {
            this.markupDocBuilder.textLine(info.getDescription());
            this.markupDocBuilder.newLine();
        }
        if (StringUtils.isNotBlank((CharSequence)info.getVersion())) {
            this.markupDocBuilder.sectionTitleLevel2(this.CURRENT_VERSION);
            this.markupDocBuilder.textLine(this.VERSION + info.getVersion());
            this.markupDocBuilder.newLine();
        }
        if ((contact = info.getContact()) != null) {
            this.markupDocBuilder.sectionTitleLevel2(this.CONTACT_INFORMATION);
            if (StringUtils.isNotBlank((CharSequence)contact.getName())) {
                this.markupDocBuilder.textLine(this.CONTACT_NAME + contact.getName());
            }
            if (StringUtils.isNotBlank((CharSequence)contact.getEmail())) {
                this.markupDocBuilder.textLine(this.CONTACT_EMAIL + contact.getEmail());
            }
            this.markupDocBuilder.newLine();
        }
        if ((license = info.getLicense()) != null && (StringUtils.isNotBlank((CharSequence)license.getName()) || StringUtils.isNotBlank((CharSequence)license.getUrl()))) {
            this.markupDocBuilder.sectionTitleLevel2(this.LICENSE_INFORMATION);
            if (StringUtils.isNotBlank((CharSequence)license.getName())) {
                this.markupDocBuilder.textLine(this.LICENSE + license.getName());
            }
            if (StringUtils.isNotBlank((CharSequence)license.getUrl())) {
                this.markupDocBuilder.textLine(this.LICENSE_URL + license.getUrl());
            }
            this.markupDocBuilder.newLine();
        }
        if (StringUtils.isNotBlank((CharSequence)info.getTermsOfService())) {
            this.markupDocBuilder.textLine(this.TERMS_OF_SERVICE + info.getTermsOfService());
            this.markupDocBuilder.newLine();
        }
        if (StringUtils.isNotBlank((CharSequence)this.swagger.getHost()) || StringUtils.isNotBlank((CharSequence)this.swagger.getBasePath()) || CollectionUtils.isNotEmpty((Collection)this.swagger.getSchemes())) {
            this.markupDocBuilder.sectionTitleLevel2(this.URI_SCHEME);
            if (StringUtils.isNotBlank((CharSequence)this.swagger.getHost())) {
                this.markupDocBuilder.textLine(this.HOST + this.swagger.getHost());
            }
            if (StringUtils.isNotBlank((CharSequence)this.swagger.getBasePath())) {
                this.markupDocBuilder.textLine(this.BASE_PATH + this.swagger.getBasePath());
            }
            if (CollectionUtils.isNotEmpty((Collection)this.swagger.getSchemes())) {
                ArrayList<String> schemes = new ArrayList<String>();
                for (Scheme scheme : this.swagger.getSchemes()) {
                    schemes.add(scheme.toString());
                }
                this.markupDocBuilder.textLine(this.SCHEMES + StringUtils.join(schemes, (String)", "));
            }
            this.markupDocBuilder.newLine();
        }
        if (CollectionUtils.isNotEmpty((Collection)this.swagger.getTags())) {
            this.markupDocBuilder.sectionTitleLevel2(this.TAGS);
            ArrayList<String> tags = new ArrayList<String>();
            for (Tag tag : this.swagger.getTags()) {
                String name = tag.getName();
                String description = tag.getDescription();
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{description})) {
                    tags.add(name + ": " + description);
                    continue;
                }
                tags.add(name);
            }
            this.markupDocBuilder.unorderedList(tags);
            this.markupDocBuilder.newLine();
        }
        if (CollectionUtils.isNotEmpty((Collection)this.swagger.getConsumes())) {
            this.markupDocBuilder.sectionTitleLevel2(this.CONSUMES);
            this.markupDocBuilder.unorderedList(this.swagger.getConsumes());
            this.markupDocBuilder.newLine();
        }
        if (CollectionUtils.isNotEmpty((Collection)this.swagger.getProduces())) {
            this.markupDocBuilder.sectionTitleLevel2(this.PRODUCES);
            this.markupDocBuilder.unorderedList(this.swagger.getProduces());
            this.markupDocBuilder.newLine();
        }
    }
}

