/*
 * Decompiled with CFR 0.152.
 */
package com.xpc.easyes.autoconfig.config;

import com.xpc.easyes.autoconfig.config.EsConfigProperties;
import com.xpc.easyes.autoconfig.constants.PropertyKeyConstants;
import com.xpc.easyes.core.cache.GlobalConfigCache;
import com.xpc.easyes.core.config.GlobalConfig;
import com.xpc.easyes.core.enums.FieldStrategy;
import com.xpc.easyes.core.enums.IdType;
import com.xpc.easyes.core.toolkit.ExceptionUtils;
import com.xpc.easyes.core.toolkit.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@EnableConfigurationProperties(value={EsConfigProperties.class})
@ConditionalOnClass(value={RestHighLevelClient.class})
@ConditionalOnProperty(prefix="easy-es", name={"enable"}, havingValue="true", matchIfMissing=true)
public class EsAutoConfiguration
implements InitializingBean,
EnvironmentAware,
PropertyKeyConstants {
    @Autowired
    private EsConfigProperties esConfigProperties;
    private Environment environment;

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    @Bean
    @ConditionalOnMissingBean
    public RestHighLevelClient restHighLevelClient() {
        boolean needSetRequestConfig;
        boolean needSetHttpClient;
        String address = this.environment.getProperty("easy-es.address");
        if (StringUtils.isEmpty((CharSequence)address)) {
            throw ExceptionUtils.eee((String)"please config the es address", (Object[])new Object[0]);
        }
        if (!address.contains(":")) {
            throw ExceptionUtils.eee((String)"the address must contains port and separate by ':'", (Object[])new Object[0]);
        }
        String schema = StringUtils.isEmpty((CharSequence)this.esConfigProperties.getSchema()) ? "http" : this.esConfigProperties.getSchema();
        ArrayList hostList = new ArrayList();
        Arrays.stream(this.esConfigProperties.getAddress().split(",")).forEach(item -> hostList.add(new HttpHost(item.split(":")[0], Integer.parseInt(item.split(":")[1]), schema)));
        HttpHost[] httpHost = hostList.toArray(new HttpHost[0]);
        RestClientBuilder builder = RestClient.builder((HttpHost[])httpHost);
        String username = this.esConfigProperties.getUsername();
        String password = this.esConfigProperties.getPassword();
        Integer maxConnTotal = this.esConfigProperties.getMaxConnTotal();
        Integer maxConnPerRoute = this.esConfigProperties.getMaxConnPerRoute();
        boolean bl = needSetHttpClient = StringUtils.isNotEmpty((CharSequence)username) && StringUtils.isNotEmpty((CharSequence)password) || Objects.nonNull(maxConnTotal) || Objects.nonNull(maxConnPerRoute);
        if (needSetHttpClient) {
            builder.setHttpClientConfigCallback(httpClientBuilder -> {
                Optional.ofNullable(maxConnTotal).ifPresent(arg_0 -> ((HttpAsyncClientBuilder)httpClientBuilder).setMaxConnTotal(arg_0));
                Optional.ofNullable(maxConnPerRoute).ifPresent(arg_0 -> ((HttpAsyncClientBuilder)httpClientBuilder).setMaxConnPerRoute(arg_0));
                if (StringUtils.isNotEmpty((CharSequence)username) && StringUtils.isNotEmpty((CharSequence)password)) {
                    BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                    credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.esConfigProperties.getUsername(), this.esConfigProperties.getPassword()));
                    httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
                }
                return httpClientBuilder;
            });
        }
        Integer connectTimeOut = this.esConfigProperties.getConnectTimeout();
        Integer socketTimeOut = this.esConfigProperties.getSocketTimeout();
        Integer requestTimeOut = this.esConfigProperties.getRequestTimeout();
        Integer connectionRequestTimeOut = this.esConfigProperties.getConnectionRequestTimeout();
        boolean bl2 = needSetRequestConfig = Objects.nonNull(connectTimeOut) || Objects.nonNull(requestTimeOut) || Objects.nonNull(connectionRequestTimeOut);
        if (needSetRequestConfig) {
            builder.setRequestConfigCallback(requestConfigBuilder -> {
                Optional.ofNullable(connectTimeOut).ifPresent(arg_0 -> ((RequestConfig.Builder)requestConfigBuilder).setConnectTimeout(arg_0));
                Optional.ofNullable(socketTimeOut).ifPresent(arg_0 -> ((RequestConfig.Builder)requestConfigBuilder).setSocketTimeout(arg_0));
                Optional.ofNullable(connectionRequestTimeOut).ifPresent(arg_0 -> ((RequestConfig.Builder)requestConfigBuilder).setConnectionRequestTimeout(arg_0));
                return requestConfigBuilder;
            });
        }
        return new RestHighLevelClient(builder);
    }

    public void afterPropertiesSet() throws Exception {
        GlobalConfig globalConfig = new GlobalConfig();
        GlobalConfig.DbConfig dbConfig = new GlobalConfig.DbConfig();
        Optional.ofNullable(this.environment.getProperty("easy-es.global-config.db-config.table-prefix")).ifPresent(arg_0 -> ((GlobalConfig.DbConfig)dbConfig).setTablePrefix(arg_0));
        Optional.ofNullable(this.environment.getProperty("easy-es.global-config.db-config.id-type")).ifPresent(i -> dbConfig.setIdType(Enum.valueOf(IdType.class, i.toUpperCase(Locale.ROOT))));
        Optional.ofNullable(this.environment.getProperty("easy-es.global-config.db-config.field-strategy")).ifPresent(f -> dbConfig.setFieldStrategy(Enum.valueOf(FieldStrategy.class, f.toUpperCase(Locale.ROOT))));
        globalConfig.setDbConfig(dbConfig);
        GlobalConfigCache.setGlobalConfig((GlobalConfig)globalConfig);
    }
}

