/*
 * Decompiled with CFR 0.152.
 */
package io.github.yedaxia.apidocs.plugin.rap;

class DataType {
    public static String STRING = "string";
    public static String NUMBER = "number";
    public static String BOOLEAN = "boolean";
    public static String OBJECT = "object";
    public static String ARRAY = "array";
    public static String ARRAY_NUMBER = "array<number>";
    public static String ARRAY_STRING = "array<string>";
    public static String ARRAY_BOOLEAN = "array<boolean>";
    public static String ARRAY_OBJECT = "array<object>";
    public static final String MOCK = "@mock=";

    DataType() {
    }

    public static String rapTypeOfNode(String nodeType) {
        String pType = nodeType;
        if (pType == null || pType.length() == 0) {
            return STRING;
        }
        if (DataType.isBooleanType(pType)) {
            return BOOLEAN;
        }
        if (DataType.isStringType(pType)) {
            return STRING;
        }
        if (DataType.isNumberType(pType)) {
            return NUMBER;
        }
        if (pType.endsWith("[]")) {
            String cType = pType.replace("[]", "");
            if (DataType.isBooleanType(cType)) {
                return ARRAY_BOOLEAN;
            }
            if (DataType.isStringType(cType)) {
                return ARRAY_STRING;
            }
            if (DataType.isNumberType(cType)) {
                return ARRAY_NUMBER;
            }
            return ARRAY_OBJECT;
        }
        return OBJECT;
    }

    public static boolean isArrayType(String nodeType) {
        return nodeType != null && nodeType.endsWith("[]");
    }

    public static String mockTypeOfNode(String nodeType) {
        if (DataType.isArrayType(nodeType)) {
            nodeType = nodeType.replace("[]", "");
        }
        if (DataType.isBooleanType(nodeType)) {
            return MOCK + "@boolean".toUpperCase();
        }
        if (DataType.isFloatType(nodeType)) {
            return MOCK + "@float".toUpperCase();
        }
        if (DataType.isIntType(nodeType)) {
            return MOCK + "@integer".toUpperCase();
        }
        if (DataType.isCharType(nodeType)) {
            return MOCK + "@character".toUpperCase();
        }
        if ("date".equalsIgnoreCase(nodeType)) {
            return MOCK + "@datetime".toUpperCase();
        }
        if ("string".equalsIgnoreCase(nodeType)) {
            return MOCK + "@string".toUpperCase();
        }
        return "";
    }

    public static String mockValue(Object value) {
        return MOCK + value;
    }

    private static boolean isBooleanType(String pType) {
        return pType != null && pType.equalsIgnoreCase("boolean");
    }

    private static boolean isNumberType(String pType) {
        return pType != null && DataType.isFloatType(pType) || DataType.isIntType(pType);
    }

    private static boolean isFloatType(String pType) {
        return pType != null && (pType.equalsIgnoreCase("float") || pType.equalsIgnoreCase("double"));
    }

    private static boolean isIntType(String pType) {
        return pType != null && (pType.equalsIgnoreCase("int") || pType.equalsIgnoreCase("byte") || pType.equalsIgnoreCase("short") || pType.equalsIgnoreCase("long"));
    }

    private static boolean isStringType(String pType) {
        return pType != null && (pType.equalsIgnoreCase("date") || pType.equalsIgnoreCase("string"));
    }

    private static boolean isCharType(String pType) {
        return pType != null && ("char".equalsIgnoreCase(pType) || "Character".equalsIgnoreCase(pType));
    }
}

