/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.el.spel.function.xml;

import io.gravitee.el.spel.function.xml.XPathParseException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathExpression {
    private final javax.xml.xpath.XPathExpression xpathExpression;
    private final String expression;

    public XPathExpression(javax.xml.xpath.XPathExpression xpathExpression, String expression) {
        this.xpathExpression = xpathExpression;
        this.expression = expression;
    }

    public String toString() {
        return this.expression;
    }

    public String evaluateAsString(Node node) {
        return (String)this.evaluate(node, XPathConstants.STRING);
    }

    public List<Node> evaluateAsNodeList(Node node) {
        NodeList nodeList = (NodeList)this.evaluate(node, XPathConstants.NODESET);
        return this.toNodeList(nodeList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object evaluate(Node node, QName returnType) {
        try {
            javax.xml.xpath.XPathExpression xPathExpression = this.xpathExpression;
            synchronized (xPathExpression) {
                return this.xpathExpression.evaluate(node, returnType);
            }
        }
        catch (XPathExpressionException var6) {
            throw new XPathParseException("Could not evaluate XPath expression:" + var6.getMessage(), var6);
        }
    }

    private List<Node> toNodeList(NodeList nodeList) {
        ArrayList<Node> result = new ArrayList<Node>(nodeList.getLength());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            result.add(nodeList.item(i));
        }
        return result;
    }

    public double evaluateAsNumber(Node node) {
        return (Double)this.evaluate(node, XPathConstants.NUMBER);
    }

    public boolean evaluateAsBoolean(Node node) {
        return (Boolean)this.evaluate(node, XPathConstants.BOOLEAN);
    }

    public Node evaluateAsNode(Node node) {
        return (Node)this.evaluate(node, XPathConstants.NODE);
    }
}

