/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.fetcher.bitbucket;

import io.gravitee.fetcher.api.Fetcher;
import io.gravitee.fetcher.api.FetcherConfiguration;
import io.gravitee.fetcher.api.FetcherException;
import io.gravitee.fetcher.api.Resource;
import io.gravitee.fetcher.bitbucket.BitbucketFetcherConfiguration;
import io.gravitee.node.api.Node;
import io.gravitee.node.api.utils.NodeUtils;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.net.ProxyOptions;
import io.vertx.core.net.ProxyType;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.Base64;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.support.CronSequenceGenerator;

public class BitbucketFetcher
implements Fetcher {
    private static final Logger logger = LoggerFactory.getLogger(BitbucketFetcher.class);
    private static final String HTTPS_SCHEME = "https";
    private BitbucketFetcherConfiguration bitbucketFetcherConfiguration;
    @Autowired
    private Vertx vertx;
    @Autowired
    private Node node;
    @Value(value="${httpClient.timeout:10000}")
    private int httpClientTimeout;
    @Value(value="${httpClient.proxy.type:HTTP}")
    private String httpClientProxyType;
    @Value(value="${httpClient.proxy.http.host:#{systemProperties['http.proxyHost'] ?: 'localhost'}}")
    private String httpClientProxyHttpHost;
    @Value(value="${httpClient.proxy.http.port:#{systemProperties['http.proxyPort'] ?: 3128}}")
    private int httpClientProxyHttpPort;
    @Value(value="${httpClient.proxy.http.username:#{null}}")
    private String httpClientProxyHttpUsername;
    @Value(value="${httpClient.proxy.http.password:#{null}}")
    private String httpClientProxyHttpPassword;
    @Value(value="${httpClient.proxy.https.host:#{systemProperties['https.proxyHost'] ?: 'localhost'}}")
    private String httpClientProxyHttpsHost;
    @Value(value="${httpClient.proxy.https.port:#{systemProperties['https.proxyPort'] ?: 3128}}")
    private int httpClientProxyHttpsPort;
    @Value(value="${httpClient.proxy.https.username:#{null}}")
    private String httpClientProxyHttpsUsername;
    @Value(value="${httpClient.proxy.https.password:#{null}}")
    private String httpClientProxyHttpsPassword;

    public BitbucketFetcher(BitbucketFetcherConfiguration bitbucketFetcherConfiguration) {
        this.bitbucketFetcherConfiguration = bitbucketFetcherConfiguration;
    }

    public Resource fetch() throws FetcherException {
        this.checkRequiredFields();
        try {
            Buffer buffer = this.fetchContent().join();
            Resource resource = new Resource();
            if (buffer == null || buffer.length() == 0) {
                logger.warn("Something goes wrong, Bitbucket responds with a status 200 but the content is empty.");
            } else {
                resource.setContent((InputStream)new ByteArrayInputStream(buffer.getBytes()));
                HashMap<String, String> metadata = new HashMap<String, String>(1);
                metadata.put("edit_url", this.buildEditUrl());
                metadata.put("provider_name", "Bitbucket");
                resource.setMetadata(metadata);
            }
            return resource;
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            throw new FetcherException("Unable to fetch Bitbucket content (" + ex.getMessage() + ")", (Throwable)ex);
        }
    }

    public FetcherConfiguration getConfiguration() {
        return this.bitbucketFetcherConfiguration;
    }

    private void checkRequiredFields() throws FetcherException {
        if (this.bitbucketFetcherConfiguration.getBranchOrTag() == null || this.bitbucketFetcherConfiguration.getBitbucketUrl() == null || this.bitbucketFetcherConfiguration.getRepository() == null || this.bitbucketFetcherConfiguration.getUsername() == null || this.bitbucketFetcherConfiguration.isAutoFetch() && (this.bitbucketFetcherConfiguration.getFetchCron() == null || this.bitbucketFetcherConfiguration.getFetchCron().isEmpty())) {
            throw new FetcherException("Some required configuration attributes are missing.", null);
        }
        if (this.bitbucketFetcherConfiguration.isAutoFetch() && this.bitbucketFetcherConfiguration.getFetchCron() != null) {
            try {
                new CronSequenceGenerator(this.bitbucketFetcherConfiguration.getFetchCron());
            }
            catch (IllegalArgumentException e) {
                throw new FetcherException("Cron expression is invalid", (Throwable)e);
            }
        }
    }

    private String buildEditUrl() throws FetcherException {
        this.checkRequiredFields();
        String bitbucketUrl = this.bitbucketFetcherConfiguration.getBitbucketUrl().replace("api.", "");
        return bitbucketUrl.substring(0, bitbucketUrl.lastIndexOf(47)) + "/" + this.bitbucketFetcherConfiguration.getUsername() + "/" + this.bitbucketFetcherConfiguration.getRepository() + "/src/" + (this.bitbucketFetcherConfiguration.getBranchOrTag() == null ? "master" : this.bitbucketFetcherConfiguration.getBranchOrTag()) + "/" + this.bitbucketFetcherConfiguration.getFilepath() + "?spa=0&mode=edit";
    }

    private String getEncodedRequestUrl() throws UnsupportedEncodingException {
        String ref = this.bitbucketFetcherConfiguration.getBranchOrTag() == null || this.bitbucketFetcherConfiguration.getBranchOrTag().trim().isEmpty() ? "master" : this.bitbucketFetcherConfiguration.getBranchOrTag().trim();
        return this.bitbucketFetcherConfiguration.getBitbucketUrl().trim() + "/repositories/" + this.bitbucketFetcherConfiguration.getUsername() + "/" + this.bitbucketFetcherConfiguration.getRepository() + "/src/" + ref + "/" + this.bitbucketFetcherConfiguration.getFilepath();
    }

    private CompletableFuture<Buffer> fetchContent() throws Exception {
        Promise promise = Promise.promise();
        String url = this.getEncodedRequestUrl();
        URI requestUri = URI.create(url);
        boolean ssl = HTTPS_SCHEME.equalsIgnoreCase(requestUri.getScheme());
        HttpClientOptions options = new HttpClientOptions().setSsl(ssl).setTrustAll(true).setMaxPoolSize(1).setKeepAlive(false).setTcpKeepAlive(false).setConnectTimeout(this.httpClientTimeout);
        if (this.bitbucketFetcherConfiguration.isUseSystemProxy()) {
            ProxyOptions proxyOptions = new ProxyOptions();
            proxyOptions.setType(ProxyType.valueOf((String)this.httpClientProxyType));
            if (HTTPS_SCHEME.equals(requestUri.getScheme())) {
                proxyOptions.setHost(this.httpClientProxyHttpsHost);
                proxyOptions.setPort(this.httpClientProxyHttpsPort);
                proxyOptions.setUsername(this.httpClientProxyHttpsUsername);
                proxyOptions.setPassword(this.httpClientProxyHttpsPassword);
            } else {
                proxyOptions.setHost(this.httpClientProxyHttpHost);
                proxyOptions.setPort(this.httpClientProxyHttpPort);
                proxyOptions.setUsername(this.httpClientProxyHttpUsername);
                proxyOptions.setPassword(this.httpClientProxyHttpPassword);
            }
            options.setProxyOptions(proxyOptions);
        }
        HttpClient httpClient = this.vertx.createHttpClient(options);
        int port = requestUri.getPort() != -1 ? requestUri.getPort() : (HTTPS_SCHEME.equals(requestUri.getScheme()) ? 443 : 80);
        try {
            RequestOptions reqOptions = new RequestOptions().setMethod(HttpMethod.GET).setPort(Integer.valueOf(port)).setHost(requestUri.getHost()).setURI(requestUri.getPath()).putHeader("User-Agent", NodeUtils.userAgent((Node)this.node)).putHeader("X-Gravitee-Request-Id", io.gravitee.common.utils.UUID.toString((UUID)io.gravitee.common.utils.UUID.random())).setTimeout((long)this.httpClientTimeout).setFollowRedirects(Boolean.valueOf(true));
            if (this.bitbucketFetcherConfiguration.getLogin() != null && this.bitbucketFetcherConfiguration.getPassword() != null) {
                String encoding = Base64.getEncoder().encodeToString((this.bitbucketFetcherConfiguration.getLogin() + ":" + this.bitbucketFetcherConfiguration.getPassword()).getBytes());
                reqOptions.putHeader("Authorization", "Basic " + encoding);
            }
            httpClient.request(reqOptions).onFailure(throwable -> {
                promise.fail(throwable);
                httpClient.close();
            }).onSuccess(request -> {
                request.response(asyncResponse -> {
                    if (asyncResponse.failed()) {
                        promise.fail(asyncResponse.cause());
                        httpClient.close();
                    } else {
                        HttpClientResponse response = (HttpClientResponse)asyncResponse.result();
                        if (response.statusCode() == 200) {
                            response.bodyHandler(buffer -> {
                                promise.complete(buffer);
                                httpClient.close();
                            });
                        } else {
                            promise.fail((Throwable)new FetcherException("Unable to fetch '" + url + "'. Status code: " + response.statusCode() + ". Message: " + response.statusMessage(), null));
                            httpClient.close();
                        }
                    }
                });
                request.exceptionHandler(throwable -> {
                    try {
                        promise.fail(throwable);
                        httpClient.close();
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                });
                request.end();
            });
        }
        catch (Exception ex) {
            logger.error("Unable to fetch content using HTTP", (Throwable)ex);
            promise.fail((Throwable)ex);
        }
        return promise.future().toCompletionStage().toCompletableFuture();
    }
}

