/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.notifier.email;

import freemarker.cache.FileTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.core.TemplateClassResolver;
import freemarker.template.Configuration;
import io.gravitee.common.utils.UUID;
import io.gravitee.notifier.api.AbstractConfigurableNotifier;
import io.gravitee.notifier.api.Notification;
import io.gravitee.notifier.api.NotifierConfiguration;
import io.gravitee.notifier.email.configuration.EmailNotifierConfiguration;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.ext.mail.LoginOption;
import io.vertx.ext.mail.MailClient;
import io.vertx.ext.mail.MailConfig;
import io.vertx.ext.mail.MailMessage;
import io.vertx.ext.mail.MailResult;
import io.vertx.ext.mail.StartTLSOptions;
import io.vertx.ext.mail.impl.MailAttachmentImpl;
import jakarta.activation.MimetypesFileTypeMap;
import java.io.File;
import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;

public class EmailNotifier
extends AbstractConfigurableNotifier<EmailNotifierConfiguration>
implements InitializingBean {
    private static final String RECIPIENTS_SPLIT_REGEX = ",|;|\\s";
    static final String TYPE = "email-notifier";
    @Value(value="${notifiers.email.templates.path:${gravitee.home}/templates}")
    private String templatesPath;
    private final Configuration config = new Configuration(Configuration.VERSION_2_3_32);

    public EmailNotifier(EmailNotifierConfiguration configuration) {
        super(TYPE, (NotifierConfiguration)configuration);
    }

    public void afterPropertiesSet() throws IOException {
        this.config.setNewBuiltinClassResolver(TemplateClassResolver.SAFER_RESOLVER);
        this.config.setTemplateLoader((TemplateLoader)new FileTemplateLoader(new File(URLDecoder.decode(this.templatesPath, StandardCharsets.UTF_8))));
    }

    public CompletableFuture<Void> doSend(Notification notification, Map<String, Object> parameters) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            MailMessage mailMessage = this.prepareMailMessage(parameters);
            MailConfig mailConfig = this.prepareMailConfig();
            MailClient.createShared((Vertx)Vertx.currentContext().owner(), (MailConfig)mailConfig, (String)String.valueOf(mailConfig.getHostname().hashCode())).sendMail(mailMessage, e -> {
                if (e.succeeded()) {
                    this.logger.debug("Email {) has been send successfully! " + ((MailResult)e.result()).getMessageID());
                    future.complete(null);
                } else {
                    this.logger.error("An error occurs while sending email", e.cause());
                    future.completeExceptionally(e.cause());
                }
            });
        }
        catch (Exception ex) {
            this.logger.error("Error while sending email notification", (Throwable)ex);
            future.completeExceptionally(ex);
        }
        return future;
    }

    MailMessage prepareMailMessage(Map<String, Object> parameters) throws Exception {
        String recipients = ((EmailNotifierConfiguration)this.configuration).getTo();
        try {
            recipients = this.templatize(recipients, parameters);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Invalid email recipient(s)", ex);
        }
        if (recipients == null || recipients.isEmpty()) {
            throw new IllegalArgumentException("Invalid email recipient(s)");
        }
        MailMessage mailMessage = new MailMessage().setFrom(this.templatize(((EmailNotifierConfiguration)this.configuration).getFrom(), parameters)).setTo(Arrays.stream(recipients.split(RECIPIENTS_SPLIT_REGEX)).collect(Collectors.toList()));
        mailMessage.setSubject(this.templatize(((EmailNotifierConfiguration)this.configuration).getSubject(), parameters));
        String body = ((EmailNotifierConfiguration)this.configuration).getBody().replace("\n", "<br>");
        this.addContentInMessage(mailMessage, this.templatize(body, parameters));
        return mailMessage;
    }

    MailConfig prepareMailConfig() {
        MailConfig mailConfig = new MailConfig().setHostname(((EmailNotifierConfiguration)this.configuration).getHost()).setPort(((EmailNotifierConfiguration)this.configuration).getPort()).setTrustAll(((EmailNotifierConfiguration)this.configuration).isSslTrustAll());
        if (this.hasCredentials()) {
            mailConfig.setUsername(((EmailNotifierConfiguration)this.configuration).getUsername());
            mailConfig.setPassword(((EmailNotifierConfiguration)this.configuration).getPassword());
        } else {
            mailConfig.setLogin(LoginOption.DISABLED);
        }
        if (Objects.nonNull(((EmailNotifierConfiguration)this.configuration).getSslKeyStore())) {
            mailConfig.setKeyStore(((EmailNotifierConfiguration)this.configuration).getSslKeyStore());
        }
        if (Objects.nonNull(((EmailNotifierConfiguration)this.configuration).getSslKeyStorePassword())) {
            mailConfig.setKeyStorePassword(((EmailNotifierConfiguration)this.configuration).getSslKeyStorePassword());
        }
        if (((EmailNotifierConfiguration)this.configuration).isStartTLSEnabled()) {
            mailConfig.setStarttls(StartTLSOptions.REQUIRED);
        } else {
            mailConfig.setStarttls(StartTLSOptions.DISABLED);
        }
        if (this.hasAuthMethods()) {
            String authMethods = ((EmailNotifierConfiguration)this.configuration).getAuthMethods().stream().map(String::toUpperCase).collect(Collectors.joining(" "));
            mailConfig.setAuthMethods(authMethods);
        }
        return mailConfig;
    }

    private boolean hasAuthMethods() {
        return Objects.nonNull(((EmailNotifierConfiguration)this.configuration).getAuthMethods()) && !((EmailNotifierConfiguration)this.configuration).getAuthMethods().isEmpty();
    }

    private boolean hasCredentials() {
        return ((EmailNotifierConfiguration)this.configuration).getUsername() != null && !((EmailNotifierConfiguration)this.configuration).getUsername().isEmpty() && ((EmailNotifierConfiguration)this.configuration).getPassword() != null && !((EmailNotifierConfiguration)this.configuration).getPassword().isEmpty();
    }

    private void addContentInMessage(MailMessage mailMessage, String htmlText) throws Exception {
        Document document = Jsoup.parse((String)htmlText);
        Elements imageElements = document.getElementsByTag("img");
        List resources = imageElements.stream().filter(imageElement -> imageElement.hasAttr("src") && !imageElement.attr("src").startsWith("http")).collect(Collectors.toList());
        if (!resources.isEmpty()) {
            ArrayList<MailAttachmentImpl> mailAttachments = new ArrayList<MailAttachmentImpl>(resources.size());
            for (Element res : resources) {
                MailAttachmentImpl attachment = new MailAttachmentImpl();
                String source = res.attr("src").trim();
                boolean addAttachment = true;
                if (source.startsWith("data:image/")) {
                    String value = source.replaceFirst("^data:image/[^;]*;base64,?", "");
                    byte[] bytes = Base64.getDecoder().decode(value.getBytes(StandardCharsets.UTF_8));
                    attachment.setContentType(EmailNotifier.extractMimeType(source));
                    attachment.setData(Buffer.buffer((byte[])bytes));
                } else {
                    File file = new File(this.templatesPath, source);
                    if (file.getCanonicalPath().startsWith(this.templatesPath)) {
                        attachment.setContentType(this.getContentTypeByFileName(source));
                        attachment.setData(Buffer.buffer((byte[])Files.readAllBytes(file.toPath())));
                    } else {
                        this.logger.warn("Resource path invalid : {}", (Object)file.getPath());
                        addAttachment = false;
                    }
                }
                String contentId = UUID.random().toString();
                res.attr("src", "cid:" + contentId);
                attachment.setContentId("<" + contentId + ">");
                attachment.setDisposition("inline");
                if (!addAttachment) continue;
                mailAttachments.add(attachment);
            }
            mailMessage.setInlineAttachment(mailAttachments);
        }
        mailMessage.setHtml(document.html());
    }

    private String getContentTypeByFileName(String fileName) {
        if (fileName == null) {
            return "";
        }
        if (fileName.endsWith(".png")) {
            return "image/png";
        }
        return MimetypesFileTypeMap.getDefaultFileTypeMap().getContentType(fileName);
    }

    private static String extractMimeType(String encoded) {
        Pattern mime = Pattern.compile("^data:([a-zA-Z0-9]+/[a-zA-Z0-9]+).*,.*");
        Matcher matcher = mime.matcher(encoded);
        if (!matcher.find()) {
            return "";
        }
        return matcher.group(1).toLowerCase();
    }

    public String getTemplatesPath() {
        return this.templatesPath;
    }

    public void setTemplatesPath(String templatesPath) {
        this.templatesPath = templatesPath;
    }
}

