/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mail;

import io.vertx.core.impl.NoStackTraceThrowable;
import java.util.List;
import java.util.Objects;

public class SMTPException
extends NoStackTraceThrowable {
    private final int replyCode;
    private final List<String> replyMessages;

    public SMTPException(String message, int replyCode, List<String> replyMessages) {
        super(message + ": " + String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)Objects.requireNonNull(replyMessages)));
        this.replyCode = replyCode;
        this.replyMessages = replyMessages;
    }

    public int getReplyCode() {
        return this.replyCode;
    }

    public List<String> getReplyMessages() {
        return this.replyMessages;
    }

    public String getReplyMessage() {
        return this.replyMessages.get(0);
    }

    public boolean isPermanent() {
        return this.replyCode >= 500;
    }

    public boolean isTransient() {
        return this.replyCode >= 400 && this.replyCode < 500;
    }
}

