/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.common.util;

import io.gravitee.node.api.configuration.Configuration;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.net.ProxyOptions;
import io.vertx.core.net.ProxyType;
import java.util.Objects;

public class VertxProxyOptionsUtils {
    static final String PROXY_HOST_PROPERTY = "system.proxy.host";
    static final String PROXY_PORT_PROPERTY = "system.proxy.port";
    static final String PROXY_TYPE_PROPERTY = "system.proxy.type";
    static final String PROXY_USERNAME_PROPERTY = "system.proxy.username";
    static final String PROXY_PASSWORD_PROPERTY = "system.proxy.password";

    public static void setSystemProxy(HttpClientOptions options, Configuration configuration) {
        options.setProxyOptions(VertxProxyOptionsUtils.buildProxyOptions(configuration));
    }

    public static ProxyOptions buildProxyOptions(Configuration configuration) {
        ProxyOptions proxyOptions = new ProxyOptions();
        StringBuilder errorMessageBuilder = new StringBuilder();
        try {
            proxyOptions.setHost(configuration.getProperty(PROXY_HOST_PROPERTY));
        }
        catch (Exception e) {
            VertxProxyOptionsUtils.appendErrorMessage(errorMessageBuilder, PROXY_HOST_PROPERTY, e);
        }
        try {
            proxyOptions.setPort(VertxProxyOptionsUtils.parseProxyPort(configuration.getProperty(PROXY_PORT_PROPERTY)));
        }
        catch (Exception e) {
            VertxProxyOptionsUtils.appendErrorMessage(errorMessageBuilder, PROXY_PORT_PROPERTY, e);
        }
        try {
            proxyOptions.setType(ProxyType.valueOf((String)configuration.getProperty(PROXY_TYPE_PROPERTY)));
        }
        catch (Exception e) {
            VertxProxyOptionsUtils.appendErrorMessage(errorMessageBuilder, PROXY_TYPE_PROPERTY, e);
        }
        proxyOptions.setUsername(configuration.getProperty(PROXY_USERNAME_PROPERTY));
        proxyOptions.setPassword(configuration.getProperty(PROXY_PASSWORD_PROPERTY));
        if (errorMessageBuilder.length() > 0) {
            throw new IllegalStateException(errorMessageBuilder.toString());
        }
        return proxyOptions;
    }

    private static int parseProxyPort(String proxyPortPropertyValue) {
        return Integer.parseInt(Objects.requireNonNull(proxyPortPropertyValue, "Proxy port may not be null"));
    }

    private static void appendErrorMessage(StringBuilder messageBuilder, String property, Exception e) {
        if (messageBuilder.length() > 0) {
            messageBuilder.append(", ");
        }
        messageBuilder.append(property).append(": ").append(e.getMessage());
    }
}

