/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.policy.cache;

import io.gravitee.gateway.reactive.api.ExecutionFailure;
import io.gravitee.gateway.reactive.api.context.GenericExecutionContext;
import io.gravitee.gateway.reactive.api.context.HttpExecutionContext;
import io.gravitee.gateway.reactive.api.context.HttpRequest;
import io.gravitee.gateway.reactive.api.context.MessageExecutionContext;
import io.gravitee.gateway.reactive.api.invoker.Invoker;
import io.gravitee.gateway.reactive.api.policy.Policy;
import io.gravitee.policy.cache.CacheAction;
import io.gravitee.policy.cache.configuration.CachePolicyConfiguration;
import io.gravitee.policy.cache.configuration.SerializationMode;
import io.gravitee.policy.cache.invoker.CacheInvoker;
import io.gravitee.policy.v3.cache.CachePolicyV3;
import io.gravitee.resource.api.ResourceManager;
import io.gravitee.resource.cache.api.CacheResource;
import io.reactivex.rxjava3.core.Completable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class CachePolicy
extends CachePolicyV3
implements Policy {
    private static final Logger log = LoggerFactory.getLogger(CachePolicy.class);
    public static final String PLUGIN_ID = "cache";

    public CachePolicy(CachePolicyConfiguration cachePolicyConfiguration) {
        super(cachePolicyConfiguration);
    }

    public String id() {
        return PLUGIN_ID;
    }

    public Completable onRequest(HttpExecutionContext ctx) {
        this.setMapperSerializationMode(ctx);
        this.action = this.lookForAction(ctx.request());
        if (this.action != CacheAction.BY_PASS) {
            if (this.isCachedMethod(ctx.request().method())) {
                String cacheName = this.cachePolicyConfiguration.getCacheName();
                CacheResource cacheResource = (CacheResource)((ResourceManager)ctx.getComponent(ResourceManager.class)).getResource(cacheName, CacheResource.class);
                if (cacheResource == null) {
                    return ctx.interruptWith(new ExecutionFailure(500).message("No cache has been defined with name " + cacheName));
                }
                this.cache = cacheResource.getCache((GenericExecutionContext)ctx);
                if (this.cache == null) {
                    return ctx.interruptWith(new ExecutionFailure(500).message("No cache named [ " + cacheName + " ] has been found."));
                }
                Invoker defaultInvoker = (Invoker)ctx.getInternalAttribute("invoker");
                ctx.setInternalAttribute("invoker", (Object)new CacheInvoker(defaultInvoker, this.cache, this.action, this.cachePolicyConfiguration, this.mapper));
            } else {
                log.debug("Request {} is not a cached request, disable caching for it.", (Object)ctx.request().id());
            }
        }
        return Completable.complete();
    }

    public Completable onResponse(HttpExecutionContext ctx) {
        return Completable.error((Throwable)new UnsupportedOperationException("onResponse method is not supported by cache policy"));
    }

    public Completable onMessageRequest(MessageExecutionContext ctx) {
        return Completable.error((Throwable)new UnsupportedOperationException("onMessageRequest method is not supported by cache policy"));
    }

    public Completable onMessageResponse(MessageExecutionContext ctx) {
        return Completable.error((Throwable)new UnsupportedOperationException("onMessageResponse method is not supported by cache policy"));
    }

    private void setMapperSerializationMode(HttpExecutionContext context) {
        if (this.mapper.isSerializationModeDefined()) {
            return;
        }
        Environment environment = (Environment)context.getComponent(Environment.class);
        String serializationModeAsString = environment.getProperty("policy.cache.serialization", SerializationMode.TEXT.name());
        this.mapper.setSerializationMode(SerializationMode.valueOf(serializationModeAsString.toUpperCase()));
    }

    protected CacheAction lookForAction(HttpRequest request) {
        String cacheAction = request.headers().getFirst((CharSequence)"X-Gravitee-Cache");
        if (cacheAction == null || cacheAction.isEmpty()) {
            cacheAction = (String)request.parameters().getFirst((Object)PLUGIN_ID);
            request.parameters().remove((Object)PLUGIN_ID);
        } else {
            request.headers().remove((CharSequence)"X-Gravitee-Cache");
        }
        try {
            return cacheAction != null ? CacheAction.valueOf(cacheAction.toUpperCase()) : null;
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
    }
}

