/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.policy.cache.invoker;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.gravitee.common.http.HttpHeaders;
import io.gravitee.gateway.api.buffer.Buffer;
import io.gravitee.gateway.reactive.api.context.ExecutionContext;
import io.gravitee.gateway.reactive.api.context.HttpExecutionContext;
import io.gravitee.gateway.reactive.api.context.HttpRequest;
import io.gravitee.gateway.reactive.api.context.Response;
import io.gravitee.gateway.reactive.api.invoker.Invoker;
import io.gravitee.policy.cache.CacheAction;
import io.gravitee.policy.cache.CacheControl;
import io.gravitee.policy.cache.CacheResponse;
import io.gravitee.policy.cache.configuration.CachePolicyConfiguration;
import io.gravitee.policy.cache.mapper.CacheResponseMapper;
import io.gravitee.policy.cache.resource.CacheElement;
import io.gravitee.policy.cache.util.CacheControlUtil;
import io.gravitee.policy.cache.util.ExpiresUtil;
import io.gravitee.resource.api.ResourceManager;
import io.gravitee.resource.cache.api.Cache;
import io.gravitee.resource.cache.api.CacheResource;
import io.gravitee.resource.cache.api.Element;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.MaybeSource;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.io.Serializable;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheInvoker
implements Invoker {
    private static final Logger log = LoggerFactory.getLogger(CacheInvoker.class);
    public static final String CACHE_ENDPOINT_INVOKER_ID = "cache-endpoint-invoker";
    private final CachePolicyConfiguration cachePolicyConfiguration;
    private final Invoker delegateInvoker;
    private final Cache cache;
    private final CacheResponseMapper mapper;
    private final CacheAction action;

    public CacheInvoker(Invoker delegateInvoker, Cache cache, CacheAction action, CachePolicyConfiguration configuration, CacheResponseMapper mapper) {
        this.cachePolicyConfiguration = configuration;
        this.delegateInvoker = delegateInvoker;
        this.mapper = mapper;
        this.cache = cache;
        this.action = action;
    }

    public String getId() {
        return CACHE_ENDPOINT_INVOKER_ID;
    }

    public Completable invoke(ExecutionContext executionContext) {
        String cacheId = this.hash((HttpExecutionContext)executionContext);
        log.debug("Looking for element in cache with the key {}", (Object)cacheId);
        return Single.fromCallable(() -> Optional.ofNullable(this.cache.get((Object)cacheId))).subscribeOn(Schedulers.io()).flatMapCompletable(optElt -> {
            Response response = executionContext.response();
            if (optElt.isEmpty() || this.action == CacheAction.REFRESH) {
                if (this.action == CacheAction.REFRESH) {
                    log.info("A refresh action has been received for key {}, invoke backend with invoker {}", (Object)cacheId, (Object)this.delegateInvoker.getClass().getName());
                } else {
                    log.debug("No element for key {}, invoke backend with invoker {}", (Object)cacheId, (Object)this.delegateInvoker.getClass().getName());
                }
                return this.delegateInvoker.invoke(executionContext).andThen((CompletableSource)Completable.defer(() -> response.onBody(body -> body.doOnSuccess(buffer -> this.storeInCache(cacheId, response, (Buffer)buffer)))));
            }
            log.debug("An element has been found for key {}, returning the cached response to the initial client", (Object)cacheId);
            Element elt = (Element)optElt.get();
            try {
                CacheResponse cacheResponse = (CacheResponse)this.mapper.readValue(elt.value().toString(), CacheResponse.class);
                response.status(cacheResponse.getStatus());
                if (cacheResponse.getHeaders() != null) {
                    cacheResponse.getHeaders().forEach((key, values) -> values.forEach(value -> response.headers().add((CharSequence)key, (CharSequence)value)));
                }
                return response.onBody(body -> body.ignoreElement().andThen((MaybeSource)Maybe.just((Object)cacheResponse.getContent())));
            }
            catch (JsonProcessingException e) {
                log.warn("Cannot deserialize element with key {}, invoke backend with invoker {}", (Object)cacheId, (Object)this.delegateInvoker.getClass().getName());
                this.evictFromCache(cacheId);
                return this.delegateInvoker.invoke(executionContext);
            }
        });
    }

    private void evictFromCache(String cacheId) {
        Completable.fromAction(() -> this.cache.evict((Object)cacheId)).subscribeOn(Schedulers.io()).doOnComplete(() -> log.debug("Element {} evicted from the cache {}", (Object)cacheId, (Object)this.cache.getName())).onErrorResumeNext(err -> {
            log.warn("Element {} can't be evicted from the cache {}", new Object[]{cacheId, this.cache.getName(), err});
            return Completable.complete();
        }).subscribe();
    }

    private void storeInCache(String cacheId, Response response, Buffer buffer) {
        Completable.fromAction(() -> {
            HttpHeaders httpHeaders = new HttpHeaders();
            response.headers().forEach(entry -> httpHeaders.add((String)entry.getKey(), (String)entry.getValue()));
            CacheResponse resp = new CacheResponse();
            resp.setContent(buffer);
            resp.setStatus(response.status());
            resp.setHeaders(httpHeaders);
            long timeToLive = this.resolveTimeToLive(response);
            CacheElement element = new CacheElement(cacheId, (Serializable)((Object)this.mapper.writeValueAsString(resp)));
            element.setTimeToLive((int)timeToLive);
            this.cache.put((Element)element);
        }).subscribeOn(Schedulers.io()).doOnComplete(() -> log.debug("Element {} stored into the cache {}", (Object)cacheId, (Object)this.cache.getName())).onErrorResumeNext(err -> {
            log.warn("Element {} can't be stored into the cache {}", new Object[]{cacheId, this.cache.getName(), err});
            return Completable.complete();
        }).subscribe();
    }

    String hash(HttpExecutionContext executionContext) {
        StringBuilder sb = new StringBuilder();
        String cacheName = this.cachePolicyConfiguration.getCacheName();
        CacheResource cacheResource = (CacheResource)((ResourceManager)executionContext.getComponent(ResourceManager.class)).getResource(cacheName, CacheResource.class);
        String keySeparator = cacheResource.keySeparator();
        switch (this.cachePolicyConfiguration.getScope()) {
            case APPLICATION: {
                sb.append((String)executionContext.getAttribute("gravitee.attribute.api")).append(keySeparator);
                sb.append((String)executionContext.getAttribute("gravitee.attribute.application")).append(keySeparator);
                break;
            }
            case API: {
                sb.append((String)executionContext.getAttribute("gravitee.attribute.api")).append(keySeparator);
            }
        }
        sb.append(executionContext.request().path().hashCode()).append(keySeparator);
        sb.append(this.buildParametersKeyComponent(executionContext.request())).append(keySeparator);
        String key = this.cachePolicyConfiguration.getKey();
        if (key != null && !key.isEmpty()) {
            key = executionContext.getTemplateEngine().convert(key);
            sb.append(key);
        } else {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    private int buildParametersKeyComponent(HttpRequest request) {
        return request.parameters().entrySet().stream().sorted(Map.Entry.comparingByKey()).peek(entry -> Collections.sort((List)entry.getValue())).map(Object::toString).collect(Collectors.joining()).hashCode();
    }

    public long resolveTimeToLive(Response response) {
        long timeToLive = -1L;
        if (this.cachePolicyConfiguration.isUseResponseCacheHeaders()) {
            timeToLive = CacheInvoker.timeToLiveFromResponse(response);
        }
        if (timeToLive != -1L && this.cachePolicyConfiguration.getTimeToLiveSeconds() < timeToLive) {
            timeToLive = this.cachePolicyConfiguration.getTimeToLiveSeconds();
        }
        return timeToLive;
    }

    public static long timeToLiveFromResponse(Response response) {
        long timeToLive = -1L;
        CacheControl cacheControl = CacheControlUtil.parseCacheControl(response.headers().get((CharSequence)"Cache-Control"));
        if (cacheControl != null && cacheControl.getSMaxAge() != -1L) {
            timeToLive = cacheControl.getSMaxAge();
        } else if (cacheControl != null && cacheControl.getMaxAge() != -1L) {
            timeToLive = cacheControl.getMaxAge();
        } else {
            Instant expiresAt = ExpiresUtil.parseExpires(response.headers().getFirst((CharSequence)"Expires"));
            if (expiresAt != null) {
                long expiresInSeconds = (expiresAt.toEpochMilli() - System.currentTimeMillis()) / 1000L;
                timeToLive = expiresInSeconds < 0L ? -1L : expiresInSeconds;
            }
        }
        return timeToLive;
    }
}

