/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.policy.cache.mapper;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import io.gravitee.gateway.api.buffer.Buffer;
import io.gravitee.gateway.api.buffer.BufferFactory;
import io.gravitee.gateway.buffer.netty.BufferFactoryImpl;
import io.gravitee.policy.cache.configuration.SerializationMode;
import java.io.IOException;

public class CacheResponseMapper
extends ObjectMapper {
    private SerializationMode serializationMode = null;

    public CacheResponseMapper() {
        this.registerModule((Module)new BufferModule());
        this.enable(SerializationFeature.INDENT_OUTPUT);
        this.enable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        this.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    public void setSerializationMode(SerializationMode serializationMode) {
        this.serializationMode = serializationMode;
    }

    public boolean isSerializationModeDefined() {
        return this.serializationMode != null;
    }

    public class BufferModule
    extends SimpleModule {
        public BufferModule() {
            super("buffer");
            this.addDeserializer(Buffer.class, new BufferDeserializerModule());
            this.addSerializer(Buffer.class, new BufferSerializerModule());
        }
    }

    private class BufferSerializerModule
    extends JsonSerializer<Buffer> {
        private BufferSerializerModule() {
        }

        public void serialize(Buffer value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeStartObject();
            if (CacheResponseMapper.this.serializationMode == SerializationMode.TEXT) {
                gen.writeStringField("buffer", value.toString());
            } else if (CacheResponseMapper.this.serializationMode == SerializationMode.BINARY) {
                gen.writeBinaryField("buffer", value.getBytes());
            } else {
                throw new IllegalStateException("Serialization mode is not defined");
            }
            gen.writeEndObject();
        }
    }

    private class BufferDeserializerModule
    extends JsonDeserializer<Buffer> {
        BufferFactory factory = new BufferFactoryImpl();

        private BufferDeserializerModule() {
        }

        public Buffer deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)p.getCodec().readTree(p);
            if (node.has("buffer")) {
                if (CacheResponseMapper.this.serializationMode == SerializationMode.TEXT) {
                    return this.factory.buffer(node.get("buffer").textValue());
                }
                if (CacheResponseMapper.this.serializationMode == SerializationMode.BINARY) {
                    return this.factory.buffer(node.get("buffer").binaryValue());
                }
                throw new IllegalStateException("Serialization mode is not defined");
            }
            return null;
        }
    }
}

