/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.policy.cache.util;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Locale;

public final class ExpiresUtil {
    private static final DateTimeFormatter EXPIRES_HEADER_FORMATTER = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss z").withLocale(Locale.ENGLISH);

    private ExpiresUtil() {
    }

    public static Instant parseExpires(String expires) {
        if (expires == null) {
            return null;
        }
        try {
            return LocalDateTime.parse(expires, EXPIRES_HEADER_FORMATTER).toInstant(ZoneOffset.UTC);
        }
        catch (DateTimeParseException dtpe) {
            return null;
        }
    }
}

