/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.policy.v3.cache;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.gravitee.common.http.HttpMethod;
import io.gravitee.gateway.api.ExecutionContext;
import io.gravitee.gateway.api.Invoker;
import io.gravitee.gateway.api.Request;
import io.gravitee.gateway.api.Response;
import io.gravitee.gateway.api.buffer.Buffer;
import io.gravitee.gateway.api.handler.Handler;
import io.gravitee.gateway.api.http.HttpHeaders;
import io.gravitee.gateway.api.proxy.ProxyConnection;
import io.gravitee.gateway.api.proxy.ProxyResponse;
import io.gravitee.gateway.api.stream.ReadStream;
import io.gravitee.policy.api.PolicyChain;
import io.gravitee.policy.api.PolicyResult;
import io.gravitee.policy.api.annotations.OnRequest;
import io.gravitee.policy.api.annotations.RequireResource;
import io.gravitee.policy.cache.CacheAction;
import io.gravitee.policy.cache.CacheControl;
import io.gravitee.policy.cache.CacheResponse;
import io.gravitee.policy.cache.configuration.CachePolicyConfiguration;
import io.gravitee.policy.cache.configuration.SerializationMode;
import io.gravitee.policy.cache.mapper.CacheResponseMapper;
import io.gravitee.policy.cache.resource.CacheElement;
import io.gravitee.policy.cache.util.CacheControlUtil;
import io.gravitee.policy.cache.util.ExpiresUtil;
import io.gravitee.policy.v3.cache.proxy.CacheProxyConnection;
import io.gravitee.policy.v3.cache.proxy.EvaluableProxyResponse;
import io.gravitee.resource.api.ResourceManager;
import io.gravitee.resource.cache.api.Cache;
import io.gravitee.resource.cache.api.CacheResource;
import io.gravitee.resource.cache.api.Element;
import io.vertx.core.AsyncResult;
import io.vertx.core.Vertx;
import java.io.Serializable;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

@RequireResource
public class CachePolicyV3 {
    private static final Logger log = LoggerFactory.getLogger(CachePolicyV3.class);
    protected static final String CACHE_SERIALIZATION_MODE_KEY = "policy.cache.serialization";
    protected final CachePolicyConfiguration cachePolicyConfiguration;
    public static final String UPSTREAM_RESPONSE = "upstreamResponse";
    public static final String CACHE_ACTION_QUERY_PARAMETER = "cache";
    public static final String X_GRAVITEE_CACHE_ACTION = "X-Gravitee-Cache";
    protected Cache cache;
    protected CacheAction action;
    protected CacheResponseMapper mapper = new CacheResponseMapper();

    public CachePolicyV3(CachePolicyConfiguration cachePolicyConfiguration) {
        this.cachePolicyConfiguration = cachePolicyConfiguration;
    }

    @OnRequest
    public void onRequest(Request request, Response response, ExecutionContext executionContext, PolicyChain policyChain) {
        this.setMapperSerializationMode(executionContext);
        this.action = this.lookForAction(request);
        if (this.action != CacheAction.BY_PASS) {
            if (this.isCachedMethod(request.method())) {
                String cacheName = this.cachePolicyConfiguration.getCacheName();
                CacheResource cacheResource = (CacheResource)((ResourceManager)executionContext.getComponent(ResourceManager.class)).getResource(cacheName, CacheResource.class);
                if (cacheResource == null) {
                    policyChain.failWith(PolicyResult.failure((String)("No cache has been defined with name " + cacheName)));
                    return;
                }
                this.cache = cacheResource.getCache(executionContext);
                if (this.cache == null) {
                    policyChain.failWith(PolicyResult.failure((String)("No cache named [ " + cacheName + " ] has been found.")));
                    return;
                }
                Invoker defaultInvoker = (Invoker)executionContext.getAttribute("gravitee.attribute.request.invoker");
                executionContext.setAttribute("gravitee.attribute.request.invoker", (Object)new CacheInvoker(defaultInvoker));
            } else {
                log.debug("Request {} is not a cached request, disable caching for it.", (Object)request.id());
            }
        }
        policyChain.doNext(request, response);
    }

    String hash(ExecutionContext executionContext) {
        StringBuilder sb = new StringBuilder();
        String cacheName = this.cachePolicyConfiguration.getCacheName();
        CacheResource cacheResource = (CacheResource)((ResourceManager)executionContext.getComponent(ResourceManager.class)).getResource(cacheName, CacheResource.class);
        String keySeparator = cacheResource.keySeparator();
        switch (this.cachePolicyConfiguration.getScope()) {
            case APPLICATION: {
                sb.append(executionContext.getAttribute("gravitee.attribute.api")).append(keySeparator);
                sb.append(executionContext.getAttribute("gravitee.attribute.application")).append(keySeparator);
                break;
            }
            case API: {
                sb.append(executionContext.getAttribute("gravitee.attribute.api")).append(keySeparator);
            }
        }
        sb.append(executionContext.request().path().hashCode()).append(keySeparator);
        sb.append(this.buildParametersKeyComponent(executionContext.request())).append(keySeparator);
        String key = this.cachePolicyConfiguration.getKey();
        if (key != null && !key.isEmpty()) {
            key = executionContext.getTemplateEngine().convert(key);
            sb.append(key);
        } else {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    private int buildParametersKeyComponent(Request request) {
        return request.parameters().entrySet().stream().sorted(Map.Entry.comparingByKey()).peek(entry -> Collections.sort((List)entry.getValue())).map(Object::toString).collect(Collectors.joining()).hashCode();
    }

    public long resolveTimeToLive(ProxyResponse response) {
        long timeToLive = -1L;
        if (this.cachePolicyConfiguration.isUseResponseCacheHeaders()) {
            timeToLive = CachePolicyV3.timeToLiveFromResponse(response);
        }
        if (timeToLive != -1L && this.cachePolicyConfiguration.getTimeToLiveSeconds() < timeToLive) {
            timeToLive = this.cachePolicyConfiguration.getTimeToLiveSeconds();
        }
        return timeToLive;
    }

    public static long timeToLiveFromResponse(ProxyResponse response) {
        long timeToLive = -1L;
        CacheControl cacheControl = CacheControlUtil.parseCacheControl(response.headers().getFirst((CharSequence)"Cache-Control"));
        if (cacheControl != null && cacheControl.getSMaxAge() != -1L) {
            timeToLive = cacheControl.getSMaxAge();
        } else if (cacheControl != null && cacheControl.getMaxAge() != -1L) {
            timeToLive = cacheControl.getMaxAge();
        } else {
            Instant expiresAt = ExpiresUtil.parseExpires(response.headers().getFirst((CharSequence)"Expires"));
            if (expiresAt != null) {
                long expiresInSeconds = (expiresAt.toEpochMilli() - System.currentTimeMillis()) / 1000L;
                timeToLive = expiresInSeconds < 0L ? -1L : expiresInSeconds;
            }
        }
        return timeToLive;
    }

    private CacheAction lookForAction(Request request) {
        String cacheAction = request.headers().getFirst((CharSequence)X_GRAVITEE_CACHE_ACTION);
        if (cacheAction == null || cacheAction.isEmpty()) {
            cacheAction = (String)request.parameters().getFirst((Object)CACHE_ACTION_QUERY_PARAMETER);
            request.parameters().remove((Object)CACHE_ACTION_QUERY_PARAMETER);
        } else {
            request.headers().remove((CharSequence)X_GRAVITEE_CACHE_ACTION);
        }
        try {
            return cacheAction != null ? CacheAction.valueOf(cacheAction.toUpperCase()) : null;
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
    }

    protected boolean isCachedMethod(HttpMethod method) {
        if (this.cachePolicyConfiguration.getMethods() == null || this.cachePolicyConfiguration.getMethods().isEmpty()) {
            return method == HttpMethod.GET || method == HttpMethod.OPTIONS || method == HttpMethod.HEAD;
        }
        return this.cachePolicyConfiguration.getMethods().contains(method);
    }

    private boolean evaluate(ExecutionContext context, ProxyResponse proxyResponse, String condition) {
        if (condition != null && !condition.isEmpty()) {
            try {
                context.getTemplateEngine().getTemplateContext().setVariable(UPSTREAM_RESPONSE, (Object)new EvaluableProxyResponse(proxyResponse));
                return (Boolean)context.getTemplateEngine().getValue(condition, Boolean.class);
            }
            catch (Exception e) {
                log.error("Unable to evaluate the condition {}", (Object)e.getMessage(), (Object)e);
                return false;
            }
        }
        return true;
    }

    private void setMapperSerializationMode(ExecutionContext context) {
        if (this.mapper.isSerializationModeDefined()) {
            return;
        }
        Environment environment = (Environment)context.getComponent(Environment.class);
        String serializationModeAsString = environment.getProperty(CACHE_SERIALIZATION_MODE_KEY, SerializationMode.TEXT.name());
        this.mapper.setSerializationMode(SerializationMode.valueOf(serializationModeAsString.toUpperCase()));
    }

    class CacheInvoker
    implements Invoker {
        private final Invoker invoker;

        CacheInvoker(Invoker invoker) {
            this.invoker = invoker;
        }

        public void invoke(final ExecutionContext executionContext, final ReadStream<Buffer> stream, final Handler<ProxyConnection> connectionHandler) {
            final String cacheId = CachePolicyV3.this.hash(executionContext);
            log.debug("Looking for element in cache with the key {}", (Object)cacheId);
            Vertx vertx = (Vertx)executionContext.getComponent(Vertx.class);
            vertx.executeBlocking(promise -> {
                Element elt = CachePolicyV3.this.cache.get((Object)cacheId);
                promise.complete((Object)elt);
            }, (io.vertx.core.Handler)new io.vertx.core.Handler<AsyncResult<Element>>(){

                public void handle(AsyncResult<Element> elementAsyncResult) {
                    Element elt = (Element)elementAsyncResult.result();
                    if (elt != null && CachePolicyV3.this.action != CacheAction.REFRESH) {
                        log.debug("An element has been found for key {}, returning the cached response to the initial client", (Object)cacheId);
                        try {
                            CacheProxyConnection proxyConnection2 = new CacheProxyConnection((CacheResponse)CachePolicyV3.this.mapper.readValue(elt.value().toString(), CacheResponse.class));
                            connectionHandler.handle((Object)proxyConnection2);
                            stream.bodyHandler(arg_0 -> ((ProxyConnection)proxyConnection2).write(arg_0)).endHandler(aVoid -> proxyConnection2.end());
                        }
                        catch (JsonProcessingException e) {
                            log.error("Cannot deserialize element with key {}, invoke backend with invoker {}", (Object)cacheId, (Object)CacheInvoker.this.invoker.getClass().getName());
                        }
                        executionContext.request().resume();
                    } else {
                        if (CachePolicyV3.this.action == CacheAction.REFRESH) {
                            log.info("A refresh action has been received for key {}, invoke backend with invoker {}", (Object)cacheId, (Object)CacheInvoker.this.invoker.getClass().getName());
                        } else {
                            log.debug("No element for key {}, invoke backend with invoker {}", (Object)cacheId, (Object)CacheInvoker.this.invoker.getClass().getName());
                        }
                        CacheInvoker.this.invoker.invoke(executionContext, stream, proxyConnection -> {
                            log.debug("Put response in cache for key {} and request {}", (Object)cacheId, (Object)executionContext.request().id());
                            ProxyConnection cacheProxyConnection = new ProxyConnection(){
                                final /* synthetic */ ProxyConnection val$proxyConnection;
                                final /* synthetic */ String val$cacheId;
                                final /* synthetic */ ExecutionContext val$executionContext;
                                {
                                    this.val$proxyConnection = proxyConnection;
                                    this.val$cacheId = string;
                                    this.val$executionContext = executionContext;
                                }

                                public ProxyConnection write(Buffer buffer) {
                                    this.val$proxyConnection.write((Object)buffer);
                                    return this;
                                }

                                public void end() {
                                    this.val$proxyConnection.end();
                                }

                                public ProxyConnection responseHandler(Handler<ProxyResponse> responseHandler) {
                                    return this.val$proxyConnection.responseHandler((Handler)new CacheResponseHandler(this.val$cacheId, responseHandler, this.val$executionContext));
                                }
                            };
                            connectionHandler.handle((Object)cacheProxyConnection);
                        });
                    }
                }
            });
        }
    }

    class CacheResponseHandler
    implements Handler<ProxyResponse> {
        private final String cacheId;
        private final Handler<ProxyResponse> responseHandler;
        private final CacheResponse response = new CacheResponse();
        private final ExecutionContext executionContext;

        CacheResponseHandler(String cacheId, Handler<ProxyResponse> responseHandler, ExecutionContext executionContext) {
            this.cacheId = cacheId;
            this.responseHandler = responseHandler;
            this.executionContext = executionContext;
        }

        public void handle(ProxyResponse proxyResponse) {
            if (CachePolicyV3.this.cachePolicyConfiguration.getResponseCondition() != null && CachePolicyV3.this.evaluate(this.executionContext, proxyResponse, CachePolicyV3.this.cachePolicyConfiguration.getResponseCondition())) {
                this.responseHandler.handle((Object)new CacheProxyResponse(proxyResponse, this.cacheId));
            } else if (CachePolicyV3.this.cachePolicyConfiguration.getResponseCondition() == null && proxyResponse.status() >= 200 && proxyResponse.status() < 300) {
                this.responseHandler.handle((Object)new CacheProxyResponse(proxyResponse, this.cacheId));
            } else {
                log.debug("Response for key {} not put in cache because of the status code {} or the condition", (Object)this.cacheId, (Object)proxyResponse.status());
                this.responseHandler.handle((Object)proxyResponse);
            }
        }

        class CacheProxyResponse
        implements ProxyResponse {
            private final ProxyResponse proxyResponse;
            private final String cacheId;
            final Buffer content = Buffer.buffer();

            CacheProxyResponse(ProxyResponse proxyResponse, String cacheId) {
                this.proxyResponse = proxyResponse;
                this.cacheId = cacheId;
            }

            public ReadStream<Buffer> bodyHandler(Handler<Buffer> bodyHandler) {
                this.proxyResponse.bodyHandler(chunk -> {
                    bodyHandler.handle(chunk);
                    this.content.appendBuffer(chunk);
                });
                return this;
            }

            public ReadStream<Buffer> endHandler(Handler<Void> endHandler) {
                this.proxyResponse.endHandler(result -> {
                    endHandler.handle(result);
                    CacheResponseHandler.this.response.setStatus(this.proxyResponse.status());
                    io.gravitee.common.http.HttpHeaders headers = new io.gravitee.common.http.HttpHeaders();
                    this.proxyResponse.headers().forEach(entry -> headers.add((String)entry.getKey(), (String)entry.getValue()));
                    CacheResponseHandler.this.response.setHeaders(headers);
                    CacheResponseHandler.this.response.setContent(this.content);
                    Vertx vertx = (Vertx)CacheResponseHandler.this.executionContext.getComponent(Vertx.class);
                    vertx.executeBlocking(promise -> {
                        long timeToLive = -1L;
                        if (CachePolicyV3.this.cachePolicyConfiguration.isUseResponseCacheHeaders()) {
                            timeToLive = CachePolicyV3.this.resolveTimeToLive(this.proxyResponse);
                        }
                        if (timeToLive == -1L || CachePolicyV3.this.cachePolicyConfiguration.getTimeToLiveSeconds() < timeToLive) {
                            timeToLive = CachePolicyV3.this.cachePolicyConfiguration.getTimeToLiveSeconds();
                        }
                        try {
                            CacheElement element = new CacheElement(this.cacheId, (Serializable)((Object)CachePolicyV3.this.mapper.writeValueAsString(CacheResponseHandler.this.response)));
                            element.setTimeToLive((int)timeToLive);
                            CachePolicyV3.this.cache.put((Element)element);
                        }
                        catch (JsonProcessingException e) {
                            log.error("Cannot serialize element with key {}", (Object)this.cacheId);
                        }
                        promise.complete();
                    }, objectAsyncResult -> {});
                });
                return this;
            }

            public ReadStream<Buffer> pause() {
                return this.proxyResponse.pause();
            }

            public ReadStream<Buffer> resume() {
                return this.proxyResponse.resume();
            }

            public int status() {
                return this.proxyResponse.status();
            }

            public HttpHeaders headers() {
                return this.proxyResponse.headers();
            }
        }
    }
}

