/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.policy.v3.cache.proxy;

import io.gravitee.gateway.api.buffer.Buffer;
import io.gravitee.gateway.api.handler.Handler;
import io.gravitee.gateway.api.http.HttpHeaders;
import io.gravitee.gateway.api.proxy.ProxyConnection;
import io.gravitee.gateway.api.proxy.ProxyResponse;
import io.gravitee.gateway.api.stream.ReadStream;
import io.gravitee.policy.cache.CacheResponse;
import java.util.stream.Collectors;

public class CacheProxyConnection
implements ProxyConnection {
    private Handler<ProxyResponse> proxyResponseHandler;
    private final CacheResponse response;

    public CacheProxyConnection(CacheResponse response) {
        this.response = response;
    }

    public ProxyConnection write(Buffer buffer) {
        return this;
    }

    public void end() {
        this.proxyResponseHandler.handle((Object)new CacheProxyResponse(this.response));
    }

    public ProxyConnection responseHandler(Handler<ProxyResponse> responseHandler) {
        this.proxyResponseHandler = responseHandler;
        return this;
    }

    class CacheProxyResponse
    implements ProxyResponse {
        private Handler<Buffer> bodyHandler;
        private Handler<Void> endHandler;
        private final CacheResponse cacheResponse;
        private final HttpHeaders httpHeaders = HttpHeaders.create();

        CacheProxyResponse(CacheResponse cacheResponse) {
            this.cacheResponse = cacheResponse;
            this.cacheResponse.getHeaders().forEach((s, strings) -> this.httpHeaders.set((CharSequence)s, (Iterable)strings.stream().map(s1 -> s1).collect(Collectors.toList())));
        }

        public int status() {
            return this.cacheResponse.getStatus();
        }

        public HttpHeaders headers() {
            return this.httpHeaders;
        }

        public ProxyResponse bodyHandler(Handler<Buffer> bodyPartHandler) {
            this.bodyHandler = bodyPartHandler;
            return this;
        }

        public ProxyResponse endHandler(Handler<Void> endHandler) {
            this.endHandler = endHandler;
            return this;
        }

        public ReadStream<Buffer> resume() {
            if (this.cacheResponse.getContent() != null) {
                this.bodyHandler.handle((Object)this.cacheResponse.getContent());
            }
            this.endHandler.handle(null);
            return this;
        }
    }
}

