/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.policy.generatejwt;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.MACSigner;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jose.util.Base64;
import com.nimbusds.jose.util.IOUtils;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import io.gravitee.common.utils.UUID;
import io.gravitee.gateway.api.ExecutionContext;
import io.gravitee.gateway.api.Request;
import io.gravitee.gateway.api.Response;
import io.gravitee.policy.api.PolicyChain;
import io.gravitee.policy.api.PolicyResult;
import io.gravitee.policy.api.annotations.OnRequest;
import io.gravitee.policy.generatejwt.alg.Signature;
import io.gravitee.policy.generatejwt.configuration.GenerateJwtPolicyConfiguration;
import io.gravitee.policy.generatejwt.configuration.X509CertificateChain;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.bind.DatatypeConverter;

public class GenerateJwtPolicy {
    static final String CONTEXT_ATTRIBUTE_JWT_GENERATED = "jwt.generated";
    private final GenerateJwtPolicyConfiguration configuration;
    private static final Map<String, RSASSASigner> signers = new HashMap<String, RSASSASigner>();
    private static List<Base64> certificateChain = new ArrayList<Base64>();

    public GenerateJwtPolicy(GenerateJwtPolicyConfiguration configuration) {
        this.configuration = configuration;
    }

    @OnRequest
    public void onRequest(Request request, Response response, ExecutionContext executionContext, PolicyChain policyChain) {
        try {
            RSASSASigner signer = null;
            JWSHeader jwsHeader = null;
            if (this.configuration.getSignature() == null || this.configuration.getSignature() == Signature.RSA_RS256) {
                String hash = this.sha1(this.configuration.getContent());
                signer = this.getSigner(hash);
                JWSHeader.Builder builder = new JWSHeader.Builder(JWSAlgorithm.RS256).keyID(this.configuration.getKid());
                if (this.configuration.getX509CertificateChain() == X509CertificateChain.X5C) {
                    builder.x509CertChain(certificateChain);
                }
                jwsHeader = builder.build();
            } else if (this.configuration.getSignature() == Signature.HMAC_HS256 || this.configuration.getSignature() == Signature.HMAC_HS384 || this.configuration.getSignature() == Signature.HMAC_HS512) {
                jwsHeader = new JWSHeader.Builder(this.configuration.getSignature().getAlg()).keyID(this.configuration.getKid()).build();
                signer = new MACSigner(this.configuration.getContent());
            }
            JWTClaimsSet claimsSet = this.buildClaims(executionContext);
            SignedJWT signedJWT = new SignedJWT(jwsHeader, claimsSet);
            signedJWT.sign((JWSSigner)signer);
            String jwt = signedJWT.serialize();
            executionContext.setAttribute(CONTEXT_ATTRIBUTE_JWT_GENERATED, (Object)jwt);
            policyChain.doNext(request, response);
        }
        catch (Exception ex) {
            policyChain.failWith(PolicyResult.failure((String)("Unable to generate JWT token: " + ex.getMessage())));
        }
    }

    private RSASSASigner getSigner(String hash) throws Exception {
        RSASSASigner signer = signers.get(hash);
        if (signer == null) {
            switch (this.configuration.getKeyResolver()) {
                case PEM: {
                    String pem = IOUtils.readInputStreamToString((InputStream)this.readFile(), (Charset)Charset.defaultCharset());
                    signer = new RSASSASigner((RSAKey)JWK.parseFromPEMEncodedObjects((String)pem));
                    break;
                }
                case JKS: {
                    KeyStore keyStore = KeyStore.getInstance("JKS");
                    if (this.configuration.getStorepass() != null) {
                        keyStore.load(this.readFile(), this.configuration.getStorepass().toCharArray());
                        this.addCertificateChain(keyStore, this.configuration);
                    }
                    KeyStore.PrivateKeyEntry pkEntry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(this.configuration.getAlias(), new KeyStore.PasswordProtection(this.configuration.getKeypass().toCharArray()));
                    signer = new RSASSASigner(pkEntry.getPrivateKey(), true);
                    break;
                }
                case PKCS12: {
                    KeyStore keyStore = KeyStore.getInstance("PKCS12");
                    if (this.configuration.getStorepass() != null) {
                        keyStore.load(this.readFile(), this.configuration.getStorepass().toCharArray());
                        this.addCertificateChain(keyStore, this.configuration);
                    }
                    KeyStore.PrivateKeyEntry pkEntry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(this.configuration.getAlias(), new KeyStore.PasswordProtection(this.configuration.getStorepass().toCharArray()));
                    signer = new RSASSASigner(pkEntry.getPrivateKey(), true);
                    break;
                }
                case INLINE: {
                    signer = new RSASSASigner((RSAKey)JWK.parseFromPEMEncodedObjects((String)this.configuration.getContent()));
                    break;
                }
            }
            signers.put(hash, signer);
        }
        return signer;
    }

    private void addCertificateChain(KeyStore keyStore, GenerateJwtPolicyConfiguration configuration) throws KeyStoreException {
        certificateChain = Arrays.stream(keyStore.getCertificateChain(configuration.getAlias())).map(c -> {
            try {
                return Base64.encode((byte[])c.getEncoded());
            }
            catch (CertificateEncodingException ex) {
                throw new IllegalArgumentException("Failed to encode certificate.", ex);
            }
        }).collect(Collectors.toList());
    }

    private JWTClaimsSet buildClaims(ExecutionContext executionContext) {
        String issuer;
        String subject;
        JWTClaimsSet.Builder claimsSet = new JWTClaimsSet.Builder();
        Instant issuerTime = Instant.now();
        claimsSet.issueTime(Date.from(issuerTime));
        String jti = this.templatizeString(executionContext, this.configuration.getId());
        if (jti == null || jti.isEmpty()) {
            claimsSet.jwtID(UUID.random().toString());
        } else {
            claimsSet.jwtID(jti);
        }
        if (this.configuration.getAudiences() != null) {
            if (this.configuration.getAudiences().size() == 1) {
                String aud2 = this.templatizeString(executionContext, this.configuration.getAudiences().get(0));
                claimsSet.audience(aud2);
            } else {
                List audiences = this.configuration.getAudiences().stream().map(aud -> this.templatizeString(executionContext, (String)aud)).collect(Collectors.toList());
                claimsSet.audience(audiences);
            }
        }
        if ((subject = this.templatizeString(executionContext, this.configuration.getSubject())) != null && !subject.isEmpty()) {
            claimsSet.subject(subject);
        }
        if ((issuer = this.templatizeString(executionContext, this.configuration.getIssuer())) != null && !issuer.isEmpty()) {
            claimsSet.issuer(issuer);
        }
        if (this.configuration.getExpiresIn() > 0L) {
            Instant expiresIn = issuerTime.plus(this.configuration.getExpiresIn(), ChronoUnit.valueOf(this.configuration.getExpiresInUnit().name()));
            claimsSet.expirationTime(Date.from(expiresIn));
        }
        if (this.configuration.getCustomClaims() != null && !this.configuration.getCustomClaims().isEmpty()) {
            this.configuration.getCustomClaims().forEach(claim -> claimsSet.claim(claim.getName(), this.templatizeObject(executionContext, claim.getValue())));
        }
        return claimsSet.build();
    }

    private Object templatizeObject(ExecutionContext executionContext, String value) {
        if (value == null || value.isEmpty()) {
            return value;
        }
        return executionContext.getTemplateEngine().getValue(value, Object.class);
    }

    private String templatizeString(ExecutionContext executionContext, String value) {
        if (value == null || value.isEmpty()) {
            return value;
        }
        return executionContext.getTemplateEngine().convert(value);
    }

    private InputStream readFile() throws FileNotFoundException {
        return new FileInputStream(this.configuration.getContent());
    }

    public String sha1(String input) {
        String sha1 = null;
        try {
            MessageDigest msdDigest = MessageDigest.getInstance("SHA-1");
            msdDigest.update(input.getBytes(Charset.defaultCharset()), 0, input.length());
            sha1 = DatatypeConverter.printHexBinary((byte[])msdDigest.digest());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return sha1;
    }
}

