/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.policy.ratelimit;

import io.gravitee.common.util.Maps;
import io.gravitee.gateway.api.ExecutionContext;
import io.gravitee.gateway.api.Request;
import io.gravitee.gateway.api.Response;
import io.gravitee.policy.api.PolicyChain;
import io.gravitee.policy.api.PolicyResult;
import io.gravitee.policy.api.annotations.OnRequest;
import io.gravitee.policy.ratelimit.configuration.RateLimitConfiguration;
import io.gravitee.policy.ratelimit.configuration.RateLimitPolicyConfiguration;
import io.gravitee.policy.ratelimit.utils.DateUtils;
import io.gravitee.repository.ratelimit.api.RateLimitService;
import io.gravitee.repository.ratelimit.model.RateLimit;
import io.reactivex.rxjava3.core.SingleObserver;
import io.reactivex.rxjava3.disposables.Disposable;
import io.vertx.rxjava3.core.Context;
import io.vertx.rxjava3.core.RxHelper;
import io.vertx.rxjava3.core.Vertx;
import java.util.Map;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RateLimitPolicy {
    private static final Logger LOGGER = LoggerFactory.getLogger(RateLimitPolicy.class);
    private static final String RATE_LIMIT_TOO_MANY_REQUESTS = "RATE_LIMIT_TOO_MANY_REQUESTS";
    public static final String X_RATE_LIMIT_LIMIT = "X-Rate-Limit-Limit";
    public static final String X_RATE_LIMIT_REMAINING = "X-Rate-Limit-Remaining";
    public static final String X_RATE_LIMIT_RESET = "X-Rate-Limit-Reset";
    public static final String ATTR_OAUTH_CLIENT_ID = "oauth.client_id";
    private static char KEY_SEPARATOR = (char)58;
    private static String RATE_LIMIT_TYPE = "rl";
    private final RateLimitPolicyConfiguration rateLimitPolicyConfiguration;

    public RateLimitPolicy(RateLimitPolicyConfiguration rateLimitPolicyConfiguration) {
        this.rateLimitPolicyConfiguration = rateLimitPolicyConfiguration;
    }

    @OnRequest
    public void onRequest(final Request request, final Response response, final ExecutionContext executionContext, final PolicyChain policyChain) {
        RateLimitService rateLimitService = (RateLimitService)executionContext.getComponent(RateLimitService.class);
        final RateLimitConfiguration rateLimitConfiguration = this.rateLimitPolicyConfiguration.getRate();
        if (rateLimitService == null) {
            policyChain.failWith(PolicyResult.failure((String)"No rate-limit service has been installed."));
            return;
        }
        final String key = this.createRateLimitKey(request, executionContext, rateLimitConfiguration);
        final long limit = rateLimitConfiguration.getLimit() > 0L ? rateLimitConfiguration.getLimit() : ((Long)executionContext.getTemplateEngine().getValue(rateLimitConfiguration.getDynamicLimit(), Long.class)).longValue();
        Context context = Vertx.currentContext();
        rateLimitService.incrementAndGet(key, this.rateLimitPolicyConfiguration.isAsync(), (Supplier)new Supplier<RateLimit>(){

            @Override
            public RateLimit get() {
                long resetTimeMillis = DateUtils.getEndOfPeriod(request.timestamp(), rateLimitConfiguration.getPeriodTime(), rateLimitConfiguration.getPeriodTimeUnit());
                RateLimit rate = new RateLimit(key);
                rate.setCounter(0L);
                rate.setLimit(limit);
                rate.setResetTime(resetTimeMillis);
                rate.setSubscription((String)executionContext.getAttribute("gravitee.attribute.user-id"));
                return rate;
            }
        }).observeOn(RxHelper.scheduler((Context)context)).subscribe((SingleObserver)new SingleObserver<RateLimit>(){

            public void onSubscribe(Disposable d) {
            }

            public void onSuccess(RateLimit rateLimit) {
                if (RateLimitPolicy.this.rateLimitPolicyConfiguration.isAddHeaders()) {
                    response.headers().set((CharSequence)RateLimitPolicy.X_RATE_LIMIT_LIMIT, (CharSequence)Long.toString(limit));
                    response.headers().set((CharSequence)RateLimitPolicy.X_RATE_LIMIT_REMAINING, (CharSequence)Long.toString(Math.max(0L, limit - rateLimit.getCounter())));
                    response.headers().set((CharSequence)RateLimitPolicy.X_RATE_LIMIT_RESET, (CharSequence)Long.toString(rateLimit.getResetTime()));
                }
                if (rateLimit.getCounter() <= limit) {
                    policyChain.doNext(request, response);
                } else {
                    policyChain.failWith(RateLimitPolicy.this.createLimitExceeded(rateLimitConfiguration, limit));
                }
            }

            public void onError(Throwable throwable) {
                if (RateLimitPolicy.this.rateLimitPolicyConfiguration.isAddHeaders()) {
                    response.headers().set((CharSequence)RateLimitPolicy.X_RATE_LIMIT_LIMIT, (CharSequence)Long.toString(limit));
                    response.headers().set((CharSequence)RateLimitPolicy.X_RATE_LIMIT_REMAINING, (CharSequence)Long.toString(limit));
                    response.headers().set((CharSequence)RateLimitPolicy.X_RATE_LIMIT_RESET, (CharSequence)Long.toString(-1L));
                }
                policyChain.doNext(request, response);
            }
        });
    }

    private String createRateLimitKey(Request request, ExecutionContext executionContext, RateLimitConfiguration rateLimitConfiguration) {
        String resolvedPath = (String)executionContext.getAttribute("gravitee.attribute.resolved-path");
        StringBuilder key = new StringBuilder();
        String plan = (String)executionContext.getAttribute("gravitee.attribute.plan");
        if (plan != null) {
            key.append(executionContext.getAttribute("gravitee.attribute.plan")).append(executionContext.getAttribute("gravitee.attribute.user-id"));
        } else if (executionContext.getAttributes().containsKey(ATTR_OAUTH_CLIENT_ID)) {
            key.append(executionContext.getAttribute(ATTR_OAUTH_CLIENT_ID));
        } else {
            key.append(executionContext.getAttribute("gravitee.attribute.api"));
        }
        if (rateLimitConfiguration.getKey() != null && !rateLimitConfiguration.getKey().isEmpty()) {
            key.append(KEY_SEPARATOR).append((String)executionContext.getTemplateEngine().getValue(rateLimitConfiguration.getKey(), String.class));
        }
        key.append(KEY_SEPARATOR).append(RATE_LIMIT_TYPE);
        if (resolvedPath != null) {
            key.append(KEY_SEPARATOR).append(resolvedPath.hashCode());
        }
        return key.toString();
    }

    private PolicyResult createLimitExceeded(RateLimitConfiguration rateLimitConfiguration, long actualLimit) {
        return PolicyResult.failure((String)RATE_LIMIT_TOO_MANY_REQUESTS, (int)429, (String)("Rate limit exceeded ! You reach the limit of " + actualLimit + " requests per " + rateLimitConfiguration.getPeriodTime() + " " + rateLimitConfiguration.getPeriodTimeUnit().name().toLowerCase()), (Map)Maps.builder().put((Object)"limit", (Object)actualLimit).put((Object)"period_time", (Object)rateLimitConfiguration.getPeriodTime()).put((Object)"period_unit", (Object)rateLimitConfiguration.getPeriodTimeUnit()).build());
    }
}

