/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.policy.requestvalidation;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.gravitee.common.util.Maps;
import io.gravitee.el.TemplateEngine;
import io.gravitee.gateway.api.ExecutionContext;
import io.gravitee.gateway.api.Request;
import io.gravitee.gateway.api.Response;
import io.gravitee.gateway.api.buffer.Buffer;
import io.gravitee.gateway.api.el.EvaluableRequest;
import io.gravitee.gateway.api.stream.BufferedReadWriteStream;
import io.gravitee.gateway.api.stream.ReadWriteStream;
import io.gravitee.gateway.api.stream.SimpleReadWriteStream;
import io.gravitee.policy.api.PolicyChain;
import io.gravitee.policy.api.PolicyResult;
import io.gravitee.policy.api.annotations.OnRequest;
import io.gravitee.policy.api.annotations.OnRequestContent;
import io.gravitee.policy.requestvalidation.Constraint;
import io.gravitee.policy.requestvalidation.ConstraintViolation;
import io.gravitee.policy.requestvalidation.Rule;
import io.gravitee.policy.requestvalidation.configuration.PolicyScope;
import io.gravitee.policy.requestvalidation.configuration.RequestValidationPolicyConfiguration;
import io.gravitee.policy.requestvalidation.validator.ExpressionBasedValidator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class RequestValidationPolicy {
    private RequestValidationPolicyConfiguration configuration;
    private static final String FIELD_MESSAGE = "message";
    private static final String FIELD_CONSTRAINTS = "constraints";
    private static final String DEFAULT_MESSAGE = "Request is not valid according to constraint rules";
    private static final String REQUEST_VARIABLE = "request";
    private static final String REQUEST_VALIDATION_INVALID = "REQUEST_VALIDATION_INVALID";

    public RequestValidationPolicy(RequestValidationPolicyConfiguration configuration) {
        this.configuration = configuration;
    }

    @OnRequest
    public void onRequest(Request request, Response response, ExecutionContext executionContext, PolicyChain policyChain) {
        if (!(this.configuration.getScope() != null && this.configuration.getScope() != PolicyScope.REQUEST || this.configuration.getRules() == null || this.configuration.getRules().isEmpty())) {
            Set<ConstraintViolation> violations = this.validate(executionContext);
            if (violations.isEmpty()) {
                policyChain.doNext(request, response);
            } else {
                List messageViolations = violations.stream().map(ConstraintViolation::getMessage).collect(Collectors.toList());
                policyChain.failWith(PolicyResult.failure((String)REQUEST_VALIDATION_INVALID, (int)this.configuration.getStatus(), (String)this.createErrorPayload(violations), (Map)Maps.builder().put((Object)"violations", messageViolations).build()));
            }
        } else {
            policyChain.doNext(request, response);
        }
    }

    @OnRequestContent
    public ReadWriteStream onRequestContent(final Request request, final ExecutionContext executionContext, final PolicyChain policyChain) {
        if (this.configuration.getScope() != null && this.configuration.getScope() == PolicyScope.REQUEST_CONTENT) {
            return new BufferedReadWriteStream(){
                Buffer buffer = Buffer.buffer();

                public SimpleReadWriteStream<Buffer> write(Buffer content) {
                    this.buffer.appendBuffer(content);
                    return this;
                }

                public void end() {
                    String content = this.buffer.toString();
                    executionContext.getTemplateEngine().getTemplateContext().setVariable(RequestValidationPolicy.REQUEST_VARIABLE, (Object)new EvaluableRequest(request, content));
                    Set<ConstraintViolation> violations = RequestValidationPolicy.this.validate(executionContext);
                    if (!violations.isEmpty()) {
                        List messageViolations = violations.stream().map(ConstraintViolation::getMessage).collect(Collectors.toList());
                        policyChain.streamFailWith(PolicyResult.failure((String)RequestValidationPolicy.REQUEST_VALIDATION_INVALID, (int)RequestValidationPolicy.this.configuration.getStatus(), (String)RequestValidationPolicy.this.createErrorPayload(violations), (Map)Maps.builder().put((Object)"violations", messageViolations).build()));
                    } else {
                        if (this.buffer.length() > 0) {
                            super.write((Object)this.buffer);
                        }
                        super.end();
                    }
                }
            };
        }
        return null;
    }

    private Set<ConstraintViolation> validate(ExecutionContext executionContext) {
        LinkedHashSet<ConstraintViolation> violations = new LinkedHashSet<ConstraintViolation>();
        for (Rule rule : this.configuration.getRules()) {
            ExpressionBasedValidator validator;
            ConstraintViolation constraintViolation;
            TemplateEngine templateEngine = executionContext.getTemplateEngine();
            String input = null;
            try {
                input = (String)templateEngine.getValue(rule.getInput(), String.class);
            }
            catch (Exception e) {
                constraintViolation = new ConstraintViolation();
                constraintViolation.setMessage("Unable to evaluate expression: " + rule.getInput() + " -> It might be related to an invalid request body");
                violations.add(constraintViolation);
                return violations;
            }
            if (!rule.getIsRequired() && input == null || (constraintViolation = (validator = new ExpressionBasedValidator(executionContext.getTemplateEngine())).validate(rule.getInput(), new Constraint(rule.getConstraint()))) == null) continue;
            violations.add(constraintViolation);
        }
        return violations;
    }

    private String createErrorPayload(Set<ConstraintViolation> violations) {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode responseNode = mapper.createObjectNode();
        responseNode.put(FIELD_MESSAGE, DEFAULT_MESSAGE);
        ArrayNode constraintsNode = responseNode.putArray(FIELD_CONSTRAINTS);
        violations.forEach(constraintViolation -> constraintsNode.add(constraintViolation.getMessage()));
        try {
            return mapper.writeValueAsString((Object)responseNode);
        }
        catch (JsonProcessingException jpe) {
            return jpe.getMessage();
        }
    }
}

