/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.policy.requestvalidation.swagger;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.policy.api.swagger.Policy;
import io.gravitee.policy.api.swagger.v2.SwaggerOperationVisitor;
import io.gravitee.policy.requestvalidation.Constraint;
import io.gravitee.policy.requestvalidation.ConstraintType;
import io.gravitee.policy.requestvalidation.Rule;
import io.gravitee.policy.requestvalidation.configuration.PolicyScope;
import io.gravitee.policy.requestvalidation.configuration.RequestValidationPolicyConfiguration;
import io.swagger.models.Operation;
import io.swagger.models.Swagger;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class RequestValidationSwaggerOperationVisitor
implements SwaggerOperationVisitor {
    private final ObjectMapper mapper = new ObjectMapper();

    public RequestValidationSwaggerOperationVisitor() {
        this.mapper.configure(JsonGenerator.Feature.WRITE_NUMBERS_AS_STRINGS, true);
    }

    public Optional<Policy> visit(Swagger descriptor, Operation operation) {
        List parameters = operation.getParameters();
        ArrayList<Rule> rules = new ArrayList<Rule>();
        if (parameters != null && !parameters.isEmpty()) {
            parameters.forEach(parameter -> {
                String in;
                switch (in = parameter.getIn()) {
                    case "query": {
                        Rule rule = new Rule();
                        rule.setInput("{#request.params['" + parameter.getName() + "']}");
                        Constraint constraint = new Constraint();
                        constraint.setType(ConstraintType.NOT_NULL);
                        constraint.setMessage(parameter.getName() + " query parameter is required");
                        rule.setConstraint(constraint);
                        rules.add(rule);
                        break;
                    }
                    case "header": {
                        Rule headerRule = new Rule();
                        headerRule.setInput("{#request.headers['" + parameter.getName() + "'][0]}");
                        Constraint headerConstraint = new Constraint();
                        headerConstraint.setType(ConstraintType.NOT_NULL);
                        headerConstraint.setMessage(parameter.getName() + " header is required");
                        headerRule.setConstraint(headerConstraint);
                        rules.add(headerRule);
                    }
                }
            });
        }
        if (!rules.isEmpty()) {
            try {
                Policy policy = new Policy();
                policy.setName("policy-request-validation");
                RequestValidationPolicyConfiguration configuration = new RequestValidationPolicyConfiguration();
                configuration.setScope(PolicyScope.REQUEST);
                configuration.setStatus(400);
                configuration.setRules(rules);
                policy.setConfiguration(this.mapper.writeValueAsString((Object)configuration));
                return Optional.of(policy);
            }
            catch (JsonProcessingException e) {
                e.printStackTrace();
            }
        }
        return Optional.empty();
    }
}

