/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.policy.requestvalidation.validator;

import io.gravitee.policy.requestvalidation.validator.StringConstraintValidator;
import java.util.regex.Pattern;

public class PatternConstraintValidator
extends StringConstraintValidator {
    private boolean init = false;
    private Pattern pattern;

    @Override
    public void initialize(String ... parameters) {
        try {
            if (parameters != null && parameters.length > 0) {
                this.pattern = Pattern.compile(parameters[0]);
                this.init = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public boolean isValid(String value) {
        if (value == null) {
            return false;
        }
        return this.init && this.pattern.matcher(value).find();
    }

    @Override
    public String getMessageTemplate() {
        return "'%s' is not valid (pattern: '%s')";
    }
}

