/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.policy.rest2soap;

import io.gravitee.common.http.HttpMethod;
import io.gravitee.common.util.LinkedMultiValueMap;
import io.gravitee.el.exceptions.ELNullEvaluationException;
import io.gravitee.gateway.api.ExecutionContext;
import io.gravitee.gateway.api.Request;
import io.gravitee.gateway.api.Response;
import io.gravitee.gateway.api.buffer.Buffer;
import io.gravitee.gateway.api.http.stream.TransformableRequestStreamBuilder;
import io.gravitee.gateway.api.stream.ReadWriteStream;
import io.gravitee.policy.api.PolicyChain;
import io.gravitee.policy.api.PolicyResult;
import io.gravitee.policy.api.annotations.OnRequest;
import io.gravitee.policy.api.annotations.OnRequestContent;
import io.gravitee.policy.rest2soap.configuration.SoapTransformerPolicyConfiguration;
import io.gravitee.policy.rest2soap.el.EvaluableRequest;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestToSoapTransformerPolicy {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestToSoapTransformerPolicy.class);
    private static final String SOAP_ACTION_HEADER = "SOAPAction";
    public static final String QUERY_PARAMS_ATTRIBUTE = "gravitee.attribute.rest-to-soap.query-parameters";
    private final SoapTransformerPolicyConfiguration soapTransformerPolicyConfiguration;

    public RestToSoapTransformerPolicy(SoapTransformerPolicyConfiguration soapTransformerPolicyConfiguration) {
        this.soapTransformerPolicyConfiguration = soapTransformerPolicyConfiguration;
    }

    @OnRequest
    public void onRequest(Request request, Response response, ExecutionContext executionContext, PolicyChain policyChain) {
        LOGGER.debug("Override HTTP methods for SOAP invocation");
        executionContext.setAttribute("gravitee.attribute.request.method", (Object)HttpMethod.POST);
        if (this.soapTransformerPolicyConfiguration.isStripPath()) {
            executionContext.setAttribute("gravitee.attribute.request.endpoint", (Object)"");
        }
        if (this.soapTransformerPolicyConfiguration.getSoapAction() != null && !this.soapTransformerPolicyConfiguration.getSoapAction().trim().isEmpty()) {
            LOGGER.debug("Add a SOAPAction header to invoke SOAP WS: {}", (Object)this.soapTransformerPolicyConfiguration.getSoapAction());
            request.headers().set((CharSequence)SOAP_ACTION_HEADER, (CharSequence)this.soapTransformerPolicyConfiguration.getSoapAction());
        }
        if (!this.soapTransformerPolicyConfiguration.isPreserveQueryParams()) {
            executionContext.setAttribute(QUERY_PARAMS_ATTRIBUTE, (Object)new LinkedMultiValueMap((Map)request.parameters()));
            request.parameters().clear();
        }
        policyChain.doNext(request, response);
    }

    @OnRequestContent
    public ReadWriteStream onRequestContent(Request request, ExecutionContext executionContext, PolicyChain policyChain) {
        String charset = this.soapTransformerPolicyConfiguration.getCharset();
        String contentType = charset == null || charset.isEmpty() ? "text/xml" : "text/xml; charset=" + charset;
        return TransformableRequestStreamBuilder.on((Request)request).contentType(contentType).transform(buffer -> {
            executionContext.getTemplateEngine().getTemplateContext().setVariable("request", (Object)new EvaluableRequest(executionContext, buffer.toString()));
            String soapEnvelope = executionContext.getTemplateEngine().convert(this.soapTransformerPolicyConfiguration.getEnvelope());
            if (soapEnvelope == null) {
                policyChain.streamFailWith(PolicyResult.failure((int)500, (String)new ELNullEvaluationException(this.soapTransformerPolicyConfiguration.getEnvelope()).getMessage()));
                return null;
            }
            return Buffer.buffer((String)soapEnvelope);
        }).build();
    }
}

