/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.policy.rest2soap.swagger;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.gravitee.policy.api.swagger.Policy;
import io.gravitee.policy.api.swagger.v3.OAIOperationVisitor;
import io.gravitee.policy.rest2soap.configuration.SoapTransformerPolicyConfiguration;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import java.util.Map;
import java.util.Optional;

public class RestToSoapOAIOperationVisitor
implements OAIOperationVisitor {
    public static final String SOAP_EXTENSION_ENVELOPE = "x-graviteeio-soap-envelope";
    public static final String SOAP_EXTENSION_ACTION = "x-graviteeio-soap-action";
    private final ObjectMapper mapper = new ObjectMapper();

    public RestToSoapOAIOperationVisitor() {
        this.mapper.configure(JsonGenerator.Feature.WRITE_NUMBERS_AS_STRINGS, true);
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.mapper.enable(SerializationFeature.INDENT_OUTPUT);
    }

    public Optional<Policy> visit(OpenAPI openAPI, Operation operation) {
        Map extensions = operation.getExtensions();
        if (extensions != null && extensions.containsKey(SOAP_EXTENSION_ENVELOPE)) {
            SoapTransformerPolicyConfiguration configuration = new SoapTransformerPolicyConfiguration();
            try {
                Policy policy = new Policy();
                policy.setName("rest-to-soap");
                configuration.setEnvelope((String)extensions.get(SOAP_EXTENSION_ENVELOPE));
                configuration.setSoapAction((String)extensions.get(SOAP_EXTENSION_ACTION));
                configuration.setCharset("");
                configuration.setPreserveQueryParams(false);
                policy.setConfiguration(this.mapper.writeValueAsString((Object)configuration));
                return Optional.of(policy);
            }
            catch (JsonProcessingException e) {
                e.printStackTrace();
            }
        }
        return Optional.empty();
    }
}

