/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.policy.sslenforcement;

import io.gravitee.common.util.Maps;
import io.gravitee.gateway.api.Request;
import io.gravitee.gateway.api.Response;
import io.gravitee.policy.api.PolicyChain;
import io.gravitee.policy.api.PolicyResult;
import io.gravitee.policy.api.annotations.OnRequest;
import io.gravitee.policy.sslenforcement.configuration.SslEnforcementPolicyConfiguration;
import java.util.Iterator;
import java.util.Map;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.springframework.util.AntPathMatcher;

public class SslEnforcementPolicy {
    private final SslEnforcementPolicyConfiguration configuration;
    static final String SSL_REQUIRED = "SSL_ENFORCEMENT_SSL_REQUIRED";
    static final String AUTHENTICATION_REQUIRED = "SSL_ENFORCEMENT_AUTHENTICATION_REQUIRED";
    static final String CLIENT_FORBIDDEN = "SSL_ENFORCEMENT_CLIENT_FORBIDDEN";

    public SslEnforcementPolicy(SslEnforcementPolicyConfiguration configuration) {
        this.configuration = configuration;
    }

    @OnRequest
    public void onRequest(Request request, Response response, PolicyChain policyChain) {
        SSLSession sslSession = request.sslSession();
        if (!this.configuration.isRequiresSsl() && sslSession == null) {
            policyChain.doNext(request, response);
            return;
        }
        if (this.configuration.isRequiresSsl() && sslSession == null) {
            policyChain.failWith(PolicyResult.failure((String)SSL_REQUIRED, (int)403, (String)"Access to the resource requires SSL certificate."));
            return;
        }
        X500Principal peerPrincipal = null;
        try {
            peerPrincipal = (X500Principal)sslSession.getPeerPrincipal();
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            // empty catch block
        }
        if (this.configuration.isRequiresClientAuthentication() && peerPrincipal == null) {
            policyChain.failWith(PolicyResult.failure((String)AUTHENTICATION_REQUIRED, (int)401, (String)"Unauthorized"));
            return;
        }
        if (this.configuration.isRequiresClientAuthentication() && this.configuration.getWhitelistClientCertificates() != null && !this.configuration.getWhitelistClientCertificates().isEmpty()) {
            String name;
            X500Principal x500Principal;
            X500Name x500Name;
            X500Name peerName = new X500Name(peerPrincipal.getName());
            boolean found = false;
            Iterator<String> iterator = this.configuration.getWhitelistClientCertificates().iterator();
            while (iterator.hasNext() && !(found = this.areEqual(x500Name = new X500Name((x500Principal = new X500Principal(name = iterator.next())).getName()), peerName))) {
            }
            if (!found) {
                policyChain.failWith(PolicyResult.failure((String)CLIENT_FORBIDDEN, (int)403, (String)"You're not allowed to access this resource", (Map)Maps.builder().put((Object)"name", (Object)peerPrincipal.getName()).build()));
                return;
            }
        }
        policyChain.doNext(request, response);
    }

    private boolean areEqual(X500Name name1, X500Name name2) {
        RDN[] rdns2;
        RDN[] rdns1 = name1.getRDNs();
        if (rdns1.length != (rdns2 = name2.getRDNs()).length) {
            return false;
        }
        boolean reverse = false;
        if (rdns1[0].getFirst() != null && rdns2[0].getFirst() != null) {
            reverse = !rdns1[0].getFirst().getType().equals((ASN1Primitive)rdns2[0].getFirst().getType());
        }
        for (int i = 0; i != rdns1.length; ++i) {
            if (this.foundMatch(reverse, rdns1[i], rdns2)) continue;
            return false;
        }
        return true;
    }

    private boolean foundMatch(boolean reverse, RDN rdn, RDN[] possRDNs) {
        if (reverse) {
            for (int i = possRDNs.length - 1; i >= 0; --i) {
                if (possRDNs[i] == null || !SslEnforcementPolicy.rDNAreEqual(rdn, possRDNs[i])) continue;
                possRDNs[i] = null;
                return true;
            }
        } else {
            for (int i = 0; i != possRDNs.length; ++i) {
                if (possRDNs[i] == null || !SslEnforcementPolicy.rDNAreEqual(rdn, possRDNs[i])) continue;
                possRDNs[i] = null;
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean rDNAreEqual(RDN rdn1, RDN rdn2) {
        if (rdn1.isMultiValued()) {
            AttributeTypeAndValue[] atvs2;
            if (!rdn2.isMultiValued()) return false;
            AttributeTypeAndValue[] atvs1 = rdn1.getTypesAndValues();
            if (atvs1.length != (atvs2 = rdn2.getTypesAndValues()).length) {
                return false;
            }
            for (int i = 0; i != atvs1.length; ++i) {
                if (SslEnforcementPolicy.atvAreEqual(atvs1[i], atvs2[i])) continue;
                return false;
            }
            return true;
        } else {
            if (rdn2.isMultiValued()) return false;
            return SslEnforcementPolicy.atvAreEqual(rdn1.getFirst(), rdn2.getFirst());
        }
    }

    private static boolean atvAreEqual(AttributeTypeAndValue atv1, AttributeTypeAndValue atv2) {
        String v2;
        ASN1ObjectIdentifier o2;
        if (atv1 == atv2) {
            return true;
        }
        if (atv1 == null) {
            return false;
        }
        if (atv2 == null) {
            return false;
        }
        ASN1ObjectIdentifier o1 = atv1.getType();
        if (!o1.equals((ASN1Primitive)(o2 = atv2.getType()))) {
            return false;
        }
        AntPathMatcher matcher = new AntPathMatcher();
        String v1 = IETFUtils.canonicalize((String)IETFUtils.valueToString((ASN1Encodable)atv1.getValue()));
        return matcher.match(v1, v2 = IETFUtils.canonicalize((String)IETFUtils.valueToString((ASN1Encodable)atv2.getValue())));
    }
}

