/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.policy.transformheaders;

import io.gravitee.el.TemplateEngine;
import io.gravitee.gateway.api.http.HttpHeaders;
import io.gravitee.gateway.reactive.api.ExecutionFailure;
import io.gravitee.gateway.reactive.api.context.HttpExecutionContext;
import io.gravitee.gateway.reactive.api.context.MessageExecutionContext;
import io.gravitee.gateway.reactive.api.message.Message;
import io.gravitee.gateway.reactive.api.policy.Policy;
import io.gravitee.policy.transformheaders.configuration.TransformHeadersPolicyConfiguration;
import io.gravitee.policy.transformheaders.v3.TransformHeadersPolicyV3;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.MaybeSource;
import java.util.ArrayList;

public class TransformHeadersPolicy
extends TransformHeadersPolicyV3
implements Policy {
    private static final String TRANSFORM_HEADERS_FAILURE = "TRANSFORM_HEADERS_FAILURE";

    public TransformHeadersPolicy(TransformHeadersPolicyConfiguration configuration) {
        super(configuration);
    }

    public String id() {
        return "transform-headers";
    }

    public Completable onRequest(HttpExecutionContext ctx) {
        return Completable.defer(() -> this.transform(ctx, ctx.request().headers()));
    }

    public Completable onResponse(HttpExecutionContext ctx) {
        return Completable.defer(() -> this.transform(ctx, ctx.response().headers()));
    }

    private Completable transform(HttpExecutionContext ctx, HttpHeaders httpHeaders) {
        return this.transformHeaders(ctx.getTemplateEngine(), httpHeaders).onErrorResumeWith((CompletableSource)ctx.interruptWith(new ExecutionFailure(500).key(TRANSFORM_HEADERS_FAILURE).message("Unable to apply headers transformation")));
    }

    public Completable onMessageRequest(MessageExecutionContext ctx) {
        return ctx.request().onMessage(message -> this.transformMessageHeaders(ctx, (Message)message));
    }

    public Completable onMessageResponse(MessageExecutionContext ctx) {
        return ctx.response().onMessage(message -> this.transformMessageHeaders(ctx, (Message)message));
    }

    private Maybe<Message> transformMessageHeaders(MessageExecutionContext ctx, Message message) {
        return this.transformHeaders(ctx.getTemplateEngine(message), message.headers()).andThen((MaybeSource)Maybe.just((Object)message)).onErrorResumeWith((MaybeSource)ctx.interruptMessageWith(new ExecutionFailure(500).key(TRANSFORM_HEADERS_FAILURE).message("Unable to apply headers transformation on message")));
    }

    private Completable transformHeaders(TemplateEngine templateEngine, HttpHeaders httpHeaders) {
        return Maybe.fromCallable(this.configuration::getAddHeaders).flatMapPublisher(Flowable::fromIterable).filter(httpHeader -> httpHeader.getName() != null && !httpHeader.getName().trim().isEmpty() && httpHeader.getValue() != null).flatMapCompletable(httpHeader -> templateEngine.eval(httpHeader.getValue(), String.class).doOnSuccess(newValue -> httpHeaders.set((CharSequence)httpHeader.getName(), (CharSequence)newValue)).ignoreElement()).andThen((CompletableSource)Completable.fromRunnable(() -> {
            ArrayList headersToRemove;
            ArrayList<Object> arrayList = headersToRemove = this.configuration.getRemoveHeaders() == null ? new ArrayList() : new ArrayList<String>(this.configuration.getRemoveHeaders());
            if (httpHeaders != null && this.configuration.getWhitelistHeaders() != null && !this.configuration.getWhitelistHeaders().isEmpty()) {
                httpHeaders.names().forEach(headerName -> {
                    if (!this.configuration.getWhitelistHeaders().contains(headerName)) {
                        headersToRemove.add(headerName);
                    }
                });
            }
            headersToRemove.forEach(headerName -> {
                if (headerName != null && !headerName.trim().isEmpty()) {
                    httpHeaders.remove((CharSequence)headerName);
                }
            });
        }));
    }
}

