/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.policy.transformheaders.v3;

import io.gravitee.gateway.api.ExecutionContext;
import io.gravitee.gateway.api.Request;
import io.gravitee.gateway.api.Response;
import io.gravitee.gateway.api.buffer.Buffer;
import io.gravitee.gateway.api.el.EvaluableRequest;
import io.gravitee.gateway.api.el.EvaluableResponse;
import io.gravitee.gateway.api.http.HttpHeaders;
import io.gravitee.gateway.api.stream.BufferedReadWriteStream;
import io.gravitee.gateway.api.stream.ReadWriteStream;
import io.gravitee.gateway.api.stream.SimpleReadWriteStream;
import io.gravitee.policy.api.PolicyChain;
import io.gravitee.policy.api.annotations.OnRequest;
import io.gravitee.policy.api.annotations.OnRequestContent;
import io.gravitee.policy.api.annotations.OnResponse;
import io.gravitee.policy.api.annotations.OnResponseContent;
import io.gravitee.policy.transformheaders.configuration.PolicyScope;
import io.gravitee.policy.transformheaders.configuration.TransformHeadersPolicyConfiguration;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class TransformHeadersPolicyV3 {
    private static final Logger log = LoggerFactory.getLogger(TransformHeadersPolicyV3.class);
    protected static final String ERROR_MESSAGE_FORMAT = "[api-id:%s] [request-id:%s] [request-path:%s] %s";
    private static final String REQUEST_TEMPLATE_VARIABLE = "request";
    private static final String RESPONSE_TEMPLATE_VARIABLE = "response";
    protected final TransformHeadersPolicyConfiguration configuration;

    @OnRequest
    public void onRequest(Request request, Response response, ExecutionContext executionContext, PolicyChain policyChain) {
        if (this.configuration.getScope() == null || this.configuration.getScope() == PolicyScope.REQUEST) {
            this.transform(request.headers(), executionContext);
        }
        policyChain.doNext(request, response);
    }

    @OnResponse
    public void onResponse(Request request, Response response, ExecutionContext executionContext, PolicyChain policyChain) {
        if (this.configuration.getScope() == PolicyScope.RESPONSE) {
            this.transform(response.headers(), executionContext);
        }
        policyChain.doNext(request, response);
    }

    @OnRequestContent
    public ReadWriteStream<Buffer> onRequestContent(ExecutionContext executionContext) {
        if (this.configuration.getScope() == PolicyScope.REQUEST_CONTENT) {
            return this.createStream(PolicyScope.REQUEST_CONTENT, executionContext);
        }
        return null;
    }

    @OnResponseContent
    public ReadWriteStream<Buffer> onResponseContent(ExecutionContext executionContext) {
        if (this.configuration.getScope() == PolicyScope.RESPONSE_CONTENT) {
            return this.createStream(PolicyScope.RESPONSE_CONTENT, executionContext);
        }
        return null;
    }

    private ReadWriteStream<Buffer> createStream(final PolicyScope scope, final ExecutionContext context) {
        return new BufferedReadWriteStream(){
            Buffer buffer = Buffer.buffer();

            public SimpleReadWriteStream<Buffer> write(Buffer content) {
                this.buffer.appendBuffer(content);
                return this;
            }

            public void end() {
                TransformHeadersPolicyV3.this.initRequestResponseProperties(context, scope == PolicyScope.REQUEST_CONTENT ? this.buffer.toString() : null, scope == PolicyScope.RESPONSE_CONTENT ? this.buffer.toString() : null);
                if (scope == PolicyScope.REQUEST_CONTENT) {
                    TransformHeadersPolicyV3.this.transform(context.request().headers(), context);
                } else {
                    TransformHeadersPolicyV3.this.transform(context.response().headers(), context);
                }
                if (this.buffer.length() > 0) {
                    super.write((Object)this.buffer);
                }
                super.end();
            }
        };
    }

    private void initRequestResponseProperties(ExecutionContext context, String requestContent, String responseContent) {
        context.getTemplateEngine().getTemplateContext().setVariable(REQUEST_TEMPLATE_VARIABLE, (Object)new EvaluableRequest(context.request(), requestContent));
        context.getTemplateEngine().getTemplateContext().setVariable(RESPONSE_TEMPLATE_VARIABLE, (Object)new EvaluableResponse(context.response(), responseContent));
    }

    void transform(HttpHeaders httpHeaders, ExecutionContext executionContext) {
        ArrayList headersToRemove;
        if (this.configuration.getAddHeaders() != null) {
            this.configuration.getAddHeaders().forEach(header -> {
                if (header.getName() != null && !header.getName().trim().isEmpty()) {
                    try {
                        String extValue;
                        String string = extValue = header.getValue() != null ? executionContext.getTemplateEngine().convert(header.getValue()) : null;
                        if (extValue != null) {
                            httpHeaders.set((CharSequence)header.getName(), (CharSequence)extValue);
                        }
                    }
                    catch (Exception ex) {
                        MDC.put((String)"api", (String)String.valueOf(executionContext.getAttribute("gravitee.attribute.api")));
                        log.error(String.format(ERROR_MESSAGE_FORMAT, executionContext.getAttribute("gravitee.attribute.api"), executionContext.request().id(), executionContext.request().path(), ex.getMessage()), ex.getCause());
                        MDC.remove((String)"api");
                    }
                }
            });
        }
        ArrayList<Object> arrayList = headersToRemove = this.configuration.getRemoveHeaders() == null ? new ArrayList() : new ArrayList<String>(this.configuration.getRemoveHeaders());
        if (httpHeaders != null && this.configuration.getWhitelistHeaders() != null && !this.configuration.getWhitelistHeaders().isEmpty()) {
            httpHeaders.names().forEach(headerName -> {
                if (!this.configuration.getWhitelistHeaders().contains(headerName)) {
                    headersToRemove.add(headerName);
                }
            });
        }
        headersToRemove.forEach(headerName -> {
            if (headerName != null && !headerName.trim().isEmpty()) {
                httpHeaders.remove((CharSequence)headerName);
            }
        });
    }

    protected TransformHeadersPolicyV3(TransformHeadersPolicyConfiguration configuration) {
        this.configuration = configuration;
    }
}

