/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.reporter.api.health;

import io.gravitee.reporter.api.AbstractReportable;
import io.gravitee.reporter.api.common.Request;
import io.gravitee.reporter.api.common.Response;
import io.gravitee.reporter.api.health.Step;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class EndpointStatus
extends AbstractReportable {
    private final String id = io.gravitee.common.utils.UUID.toString((UUID)io.gravitee.common.utils.UUID.random());
    private final String api;
    private final String endpoint;
    private int state;
    private boolean available = true;
    private final boolean success;
    private long responseTime;
    private final List<Step> steps;
    private boolean transition = false;

    private EndpointStatus(long timestamp, String api, String endpoint, List<Step> steps) {
        super(timestamp);
        this.api = api;
        this.endpoint = endpoint;
        this.steps = steps;
        this.success = steps.stream().allMatch(Step::isSuccess);
    }

    public String getId() {
        return this.id;
    }

    public String getApi() {
        return this.api;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public int getState() {
        return this.state;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public List<Step> getSteps() {
        return this.steps;
    }

    public void setState(int state) {
        this.state = state;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public void setAvailable(boolean available) {
        this.available = available;
    }

    public long getResponseTime() {
        return this.responseTime;
    }

    public void setResponseTime(long responseTime) {
        this.responseTime = responseTime;
    }

    public boolean isTransition() {
        return this.transition;
    }

    public void setTransition(boolean transition) {
        this.transition = transition;
    }

    public static Builder forEndpoint(String api, String endpoint) {
        return new Builder(api, endpoint);
    }

    public static StepBuilder forStep(String step) {
        return new StepBuilder(step);
    }

    public static class StepBuilder {
        private final String step;
        private boolean success = true;
        private String message;
        private long responseTime;
        private Request request;
        private Response response;

        private StepBuilder(String step) {
            this.step = step;
        }

        public StepBuilder success() {
            this.success = true;
            return this;
        }

        public StepBuilder fail(String message) {
            this.success = false;
            this.message = message;
            return this;
        }

        public StepBuilder responseTime(long responseTime) {
            this.responseTime = responseTime;
            return this;
        }

        public StepBuilder request(Request request) {
            this.request = request;
            return this;
        }

        public StepBuilder response(Response response) {
            this.response = response;
            return this;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public Step build() {
            Step result = new Step(this.step);
            result.setSuccess(this.success);
            result.setRequest(this.request);
            result.setResponse(this.response);
            result.setMessage(this.message);
            result.setResponseTime(this.responseTime);
            return result;
        }
    }

    public static class Builder {
        private final String api;
        private final String endpoint;
        private long timestamp;
        private List<Step> steps = new ArrayList<Step>();

        private Builder(String api, String endpoint) {
            this.api = api;
            this.endpoint = endpoint;
        }

        public Builder on(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder step(Step step) {
            this.steps.add(step);
            return this;
        }

        public EndpointStatus build() {
            return new EndpointStatus(this.timestamp, this.api, this.endpoint, this.steps);
        }
    }
}

