/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.reporter.api.jackson;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.StreamWriteFeature;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.io.CharacterEscapes;
import com.fasterxml.jackson.core.io.SerializedString;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.PropertyWriter;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import io.gravitee.reporter.api.jackson.JacksonUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class FieldPropertyFilter
extends SimpleBeanPropertyFilter {
    private static final String JSON_NESTED_SEPARATOR = ".";
    private final Map<String, Boolean> cache;
    private final Map<String, String> renameFields;
    private final Set<String> excludeExpressions;
    private final Set<String> includeExpressions;
    private final boolean shouldApplyFilter;

    public FieldPropertyFilter(Map<String, String> renameFields, Set<String> includeExpressions, Set<String> excludeExpressions) {
        this.renameFields = renameFields;
        this.includeExpressions = includeExpressions;
        this.excludeExpressions = excludeExpressions;
        this.cache = new ConcurrentHashMap<String, Boolean>();
        this.shouldApplyFilter = this.shouldApplyFilter();
    }

    private boolean shouldApplyFilter() {
        return this.renameFields != null && !this.renameFields.isEmpty() || this.includeExpressions != null && !this.includeExpressions.isEmpty() || this.excludeExpressions != null && !this.excludeExpressions.isEmpty();
    }

    public void serializeAsField(Object pojo, JsonGenerator jgen, SerializerProvider provider, PropertyWriter writer) throws Exception {
        if (!this.shouldApplyFilter) {
            super.serializeAsField(pojo, jgen, provider, writer);
        } else {
            String jsonPath = JacksonUtils.resolveJsonPath(jgen.getOutputContext(), writer);
            if (this.cache.computeIfAbsent(jsonPath, k -> this.include(jgen, writer)).booleanValue()) {
                JsonGenerator generator = this.renameFields.containsKey(jsonPath) ? new RenameFieldJsonGenerator(jgen, this.renameFields.get(jsonPath)) : jgen;
                super.serializeAsField(pojo, generator, provider, writer);
            }
        }
    }

    private boolean include(JsonGenerator jgen, PropertyWriter writer) {
        String jsonPath = JacksonUtils.resolveJsonPath(jgen.getOutputContext(), writer);
        return !this.excludeExpressions.contains("*") && !this.excludeExpressions.stream().anyMatch(s -> this.matchExclude(jsonPath, (String)s)) || this.includeExpressions.stream().anyMatch(e -> this.matchInclude(jsonPath, (String)e, writer));
    }

    private boolean matchInclude(String jsonPath, String expression, PropertyWriter writer) {
        return jsonPath.equals(expression) || jsonPath.startsWith(expression + JSON_NESTED_SEPARATOR) || this.isAStructure(writer) && expression.startsWith(jsonPath + JSON_NESTED_SEPARATOR);
    }

    private boolean matchExclude(String jsonPath, String expression) {
        return jsonPath.equals(expression) || jsonPath.startsWith(expression + JSON_NESTED_SEPARATOR);
    }

    private boolean isAStructure(PropertyWriter writer) {
        return !writer.getType().isPrimitive() || writer.getType().isContainerType();
    }

    public static class RenameFieldJsonGenerator
    extends JsonGenerator {
        private final JsonGenerator wrapped;
        private final String fieldName;

        public RenameFieldJsonGenerator(JsonGenerator wrapped, String fieldName) {
            this.wrapped = wrapped;
            this.fieldName = fieldName;
        }

        public void writeFieldName(String name) throws IOException {
            this.wrapped.writeFieldName(this.fieldName);
        }

        public void writeFieldName(SerializableString name) throws IOException {
            this.wrapped.writeFieldName((SerializableString)new SerializedString(this.fieldName));
        }

        public JsonGenerator setCodec(ObjectCodec oc) {
            return this.wrapped.setCodec(oc);
        }

        public ObjectCodec getCodec() {
            return this.wrapped.getCodec();
        }

        public Version version() {
            return this.wrapped.version();
        }

        public JsonGenerator enable(JsonGenerator.Feature f) {
            return this.wrapped.enable(f);
        }

        public JsonGenerator disable(JsonGenerator.Feature f) {
            return this.wrapped.disable(f);
        }

        public boolean isEnabled(JsonGenerator.Feature f) {
            return this.wrapped.isEnabled(f);
        }

        public boolean isEnabled(StreamWriteFeature f) {
            return this.wrapped.isEnabled(f);
        }

        public int getFeatureMask() {
            return this.wrapped.getFeatureMask();
        }

        @Deprecated
        public JsonGenerator setFeatureMask(int values) {
            return this.wrapped.setFeatureMask(values);
        }

        public JsonGenerator overrideStdFeatures(int values, int mask) {
            return this.wrapped.overrideStdFeatures(values, mask);
        }

        public int getFormatFeatures() {
            return this.wrapped.getFormatFeatures();
        }

        public JsonGenerator overrideFormatFeatures(int values, int mask) {
            return this.wrapped.overrideFormatFeatures(values, mask);
        }

        public void setSchema(FormatSchema schema) {
            this.wrapped.setSchema(schema);
        }

        public FormatSchema getSchema() {
            return this.wrapped.getSchema();
        }

        public JsonGenerator setPrettyPrinter(PrettyPrinter pp) {
            return this.wrapped.setPrettyPrinter(pp);
        }

        public PrettyPrinter getPrettyPrinter() {
            return this.wrapped.getPrettyPrinter();
        }

        public JsonGenerator useDefaultPrettyPrinter() {
            return this.wrapped.useDefaultPrettyPrinter();
        }

        public JsonGenerator setHighestNonEscapedChar(int charCode) {
            return this.wrapped.setHighestNonEscapedChar(charCode);
        }

        public int getHighestEscapedChar() {
            return this.wrapped.getHighestEscapedChar();
        }

        public CharacterEscapes getCharacterEscapes() {
            return this.wrapped.getCharacterEscapes();
        }

        public JsonGenerator setCharacterEscapes(CharacterEscapes esc) {
            return this.wrapped.setCharacterEscapes(esc);
        }

        public JsonGenerator setRootValueSeparator(SerializableString sep) {
            return this.wrapped.setRootValueSeparator(sep);
        }

        public Object getOutputTarget() {
            return this.wrapped.getOutputTarget();
        }

        public int getOutputBuffered() {
            return this.wrapped.getOutputBuffered();
        }

        public Object getCurrentValue() {
            return this.wrapped.getCurrentValue();
        }

        public void setCurrentValue(Object v) {
            this.wrapped.setCurrentValue(v);
        }

        public boolean canUseSchema(FormatSchema schema) {
            return this.wrapped.canUseSchema(schema);
        }

        public boolean canWriteObjectId() {
            return this.wrapped.canWriteObjectId();
        }

        public boolean canWriteTypeId() {
            return this.wrapped.canWriteTypeId();
        }

        public boolean canWriteBinaryNatively() {
            return this.wrapped.canWriteBinaryNatively();
        }

        public boolean canOmitFields() {
            return this.wrapped.canOmitFields();
        }

        public boolean canWriteFormattedNumbers() {
            return this.wrapped.canWriteFormattedNumbers();
        }

        public void writeStartArray() throws IOException {
            this.wrapped.writeStartArray();
        }

        public void writeStartArray(int size) throws IOException {
            this.wrapped.writeStartArray(size);
        }

        public void writeStartArray(Object forValue) throws IOException {
            this.wrapped.writeStartArray(forValue);
        }

        public void writeStartArray(Object forValue, int size) throws IOException {
            this.wrapped.writeStartArray(forValue, size);
        }

        public void writeEndArray() throws IOException {
            this.wrapped.writeEndArray();
        }

        public void writeStartObject() throws IOException {
            this.wrapped.writeStartObject();
        }

        public void writeStartObject(Object forValue) throws IOException {
            this.wrapped.writeStartObject(forValue);
        }

        public void writeStartObject(Object forValue, int size) throws IOException {
            this.wrapped.writeStartObject(forValue, size);
        }

        public void writeEndObject() throws IOException {
            this.wrapped.writeEndObject();
        }

        public void writeFieldId(long id) throws IOException {
            this.wrapped.writeFieldId(id);
        }

        public void writeArray(int[] array, int offset, int length) throws IOException {
            this.wrapped.writeArray(array, offset, length);
        }

        public void writeArray(long[] array, int offset, int length) throws IOException {
            this.wrapped.writeArray(array, offset, length);
        }

        public void writeArray(double[] array, int offset, int length) throws IOException {
            this.wrapped.writeArray(array, offset, length);
        }

        public void writeString(String text) throws IOException {
            this.wrapped.writeString(text);
        }

        public void writeString(Reader reader, int len) throws IOException {
            this.wrapped.writeString(reader, len);
        }

        public void writeString(char[] text, int offset, int len) throws IOException {
            this.wrapped.writeString(text, offset, len);
        }

        public void writeString(SerializableString text) throws IOException {
            this.wrapped.writeString(text);
        }

        public void writeRawUTF8String(byte[] text, int offset, int length) throws IOException {
            this.wrapped.writeRawUTF8String(text, offset, length);
        }

        public void writeUTF8String(byte[] text, int offset, int length) throws IOException {
            this.wrapped.writeUTF8String(text, offset, length);
        }

        public void writeRaw(String text) throws IOException {
            this.wrapped.writeRaw(text);
        }

        public void writeRaw(String text, int offset, int len) throws IOException {
            this.wrapped.writeRaw(text, offset, len);
        }

        public void writeRaw(char[] text, int offset, int len) throws IOException {
            this.wrapped.writeRaw(text, offset, len);
        }

        public void writeRaw(char c) throws IOException {
            this.wrapped.writeRaw(c);
        }

        public void writeRaw(SerializableString raw) throws IOException {
            this.wrapped.writeRaw(raw);
        }

        public void writeRawValue(String text) throws IOException {
            this.wrapped.writeRawValue(text);
        }

        public void writeRawValue(String text, int offset, int len) throws IOException {
            this.wrapped.writeRawValue(text, offset, len);
        }

        public void writeRawValue(char[] text, int offset, int len) throws IOException {
            this.wrapped.writeRawValue(text, offset, len);
        }

        public void writeRawValue(SerializableString raw) throws IOException {
            this.wrapped.writeRawValue(raw);
        }

        public void writeBinary(Base64Variant bv, byte[] data, int offset, int len) throws IOException {
            this.wrapped.writeBinary(bv, data, offset, len);
        }

        public void writeBinary(byte[] data, int offset, int len) throws IOException {
            this.wrapped.writeBinary(data, offset, len);
        }

        public void writeBinary(byte[] data) throws IOException {
            this.wrapped.writeBinary(data);
        }

        public int writeBinary(InputStream data, int dataLength) throws IOException {
            return this.wrapped.writeBinary(data, dataLength);
        }

        public int writeBinary(Base64Variant bv, InputStream data, int dataLength) throws IOException {
            return this.wrapped.writeBinary(bv, data, dataLength);
        }

        public void writeNumber(short v) throws IOException {
            this.wrapped.writeNumber(v);
        }

        public void writeNumber(int v) throws IOException {
            this.wrapped.writeNumber(v);
        }

        public void writeNumber(long v) throws IOException {
            this.wrapped.writeNumber(v);
        }

        public void writeNumber(BigInteger v) throws IOException {
            this.wrapped.writeNumber(v);
        }

        public void writeNumber(double v) throws IOException {
            this.wrapped.writeNumber(v);
        }

        public void writeNumber(float v) throws IOException {
            this.wrapped.writeNumber(v);
        }

        public void writeNumber(BigDecimal v) throws IOException {
            this.wrapped.writeNumber(v);
        }

        public void writeNumber(String encodedValue) throws IOException {
            this.wrapped.writeNumber(encodedValue);
        }

        public void writeBoolean(boolean state) throws IOException {
            this.wrapped.writeBoolean(state);
        }

        public void writeNull() throws IOException {
            this.wrapped.writeNull();
        }

        public void writeEmbeddedObject(Object object) throws IOException {
            this.wrapped.writeEmbeddedObject(object);
        }

        public void writeObjectId(Object id) throws IOException {
            this.wrapped.writeObjectId(id);
        }

        public void writeObjectRef(Object id) throws IOException {
            this.wrapped.writeObjectRef(id);
        }

        public void writeTypeId(Object id) throws IOException {
            this.wrapped.writeTypeId(id);
        }

        public WritableTypeId writeTypePrefix(WritableTypeId typeIdDef) throws IOException {
            return this.wrapped.writeTypePrefix(typeIdDef);
        }

        public WritableTypeId writeTypeSuffix(WritableTypeId typeIdDef) throws IOException {
            return this.wrapped.writeTypeSuffix(typeIdDef);
        }

        public void writeObject(Object pojo) throws IOException {
            this.wrapped.writeObject(pojo);
        }

        public void writeTree(TreeNode rootNode) throws IOException {
            this.wrapped.writeTree(rootNode);
        }

        public void writeStringField(String fieldName, String value) throws IOException {
            this.wrapped.writeStringField(fieldName, value);
        }

        public void writeOmittedField(String fieldName) throws IOException {
            this.wrapped.writeOmittedField(fieldName);
        }

        public void copyCurrentEvent(JsonParser p) throws IOException {
            this.wrapped.copyCurrentEvent(p);
        }

        public void copyCurrentStructure(JsonParser p) throws IOException {
            this.wrapped.copyCurrentStructure(p);
        }

        public JsonStreamContext getOutputContext() {
            return this.wrapped.getOutputContext();
        }

        public void flush() throws IOException {
            this.wrapped.flush();
        }

        public boolean isClosed() {
            return this.wrapped.isClosed();
        }

        public void close() throws IOException {
            this.wrapped.close();
        }
    }
}

