/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.reporter.api.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import io.gravitee.gateway.api.http.HttpHeaders;
import io.gravitee.reporter.api.configuration.Rules;
import io.gravitee.reporter.api.jackson.JacksonUtils;
import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class HttpHeadersSerializer
extends StdSerializer<HttpHeaders> {
    private final transient Rules rules;

    @Deprecated(since="1.23", forRemoval=true)
    public HttpHeadersSerializer() {
        super(HttpHeaders.class);
        this.rules = new Rules();
    }

    public HttpHeadersSerializer(Rules rules) {
        super(HttpHeaders.class);
        this.rules = Objects.requireNonNullElseGet(rules, Rules::new);
    }

    public void serialize(HttpHeaders httpHeaders, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
        String baseJsonPath = JacksonUtils.resolveJsonPath(jsonGenerator.getOutputContext(), null) + jsonGenerator.getOutputContext().getCurrentName();
        jsonGenerator.writeStartObject();
        for (String httpHeaderName : this.getHeadersToIncludeAccordingToRules(baseJsonPath, httpHeaders)) {
            jsonGenerator.writeFieldName(httpHeaderName);
            jsonGenerator.writeStartArray();
            for (String headerValue : httpHeaders.getAll((CharSequence)httpHeaderName)) {
                jsonGenerator.writeString(headerValue);
            }
            jsonGenerator.writeEndArray();
        }
        jsonGenerator.writeEndObject();
    }

    private Set<String> getHeadersToIncludeAccordingToRules(String baseJsonPath, HttpHeaders httpHeaders) {
        if (this.rules.getIncludeFields().contains(baseJsonPath)) {
            return httpHeaders.names();
        }
        return httpHeaders.names().stream().filter(header -> {
            String headerPath = baseJsonPath + "." + header;
            return !this.rules.getExcludeFields().contains("*") && !this.rules.getExcludeFields().contains(headerPath) || this.rules.getIncludeFields().contains(headerPath);
        }).collect(Collectors.toSet());
    }
}

