/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.reporter.api.jackson;

import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.databind.ser.PropertyWriter;

public final class JacksonUtils {
    private static final char JSON_NESTED_SEPARATOR = '.';

    public static String resolveJsonPath(JsonStreamContext context, PropertyWriter writer) {
        StringBuilder sb = new StringBuilder(writer != null ? writer.getName() : "");
        JsonStreamContext parent = JacksonUtils.getRealParent(context);
        while (parent != null) {
            if (parent.hasCurrentName()) {
                sb.insert(0, '.').insert(0, parent.getCurrentName());
            }
            parent = JacksonUtils.getRealParent(parent);
        }
        return sb.toString();
    }

    private static JsonStreamContext getRealParent(JsonStreamContext context) {
        if (context == null || context.inRoot()) {
            return null;
        }
        JsonStreamContext parent = context.getParent();
        if (parent == null) {
            return null;
        }
        if (parent.inArray()) {
            return JacksonUtils.getRealParent(parent);
        }
        return parent;
    }
}

