/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.reporter.api.monitor;

public final class JvmInfo {
    public long timestamp = -1L;
    public long uptime;
    public Mem mem;
    public Threads threads;
    public GarbageCollectors gc;

    public JvmInfo(long timestamp, long uptime) {
        this.timestamp = timestamp;
        this.uptime = uptime;
    }

    public static class GarbageCollector {
        public String name;
        public long collectionCount;
        public long collectionTime;

        public String getName() {
            return this.name;
        }

        public long getCollectionTime() {
            return this.collectionTime;
        }

        public long getCollectionCount() {
            return this.collectionCount;
        }
    }

    public static class GarbageCollectors {
        public GarbageCollector[] collectors;
    }

    public static class Threads {
        public int count;
        public int peakCount;

        public int getCount() {
            return this.count;
        }

        public int getPeakCount() {
            return this.peakCount;
        }
    }

    public static class MemoryPool {
        public String name;
        public long used;
        public long max;
        public long peakUsed;
        public long peakMax;

        public MemoryPool(String name, long used, long max, long peakUsed, long peakMax) {
            this.name = name;
            this.used = used;
            this.max = max;
            this.peakUsed = peakUsed;
            this.peakMax = peakMax;
        }

        public String getName() {
            return this.name;
        }

        public long getUsed() {
            return this.used;
        }

        public long getMax() {
            return this.max;
        }

        public long getPeakUsed() {
            return this.peakUsed;
        }

        public long getPeakMax() {
            return this.peakMax;
        }
    }

    public static class Mem {
        public long heapCommitted;
        public long heapUsed;
        public long heapMax;
        public long nonHeapCommitted;
        public long nonHeapUsed;
        public MemoryPool[] pools = new MemoryPool[0];

        public short getHeapUsedPercent() {
            if (this.heapMax == 0L) {
                return -1;
            }
            return (short)(this.heapUsed * 100L / this.heapMax);
        }
    }
}

