/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.reporter.api.monitor;

import io.gravitee.reporter.api.AbstractReportable;
import io.gravitee.reporter.api.monitor.JvmInfo;
import io.gravitee.reporter.api.monitor.OsInfo;
import io.gravitee.reporter.api.monitor.ProcessInfo;

public class Monitor
extends AbstractReportable {
    JvmInfo jvm;
    OsInfo os;
    ProcessInfo process;

    public Monitor(long timestamp) {
        super(timestamp);
    }

    public JvmInfo getJvm() {
        return this.jvm;
    }

    public OsInfo getOs() {
        return this.os;
    }

    public ProcessInfo getProcess() {
        return this.process;
    }

    public static Builder on(String gateway) {
        return new Builder();
    }

    public static class Builder {
        private long timestamp;
        private OsInfo os;
        private JvmInfo jvm;
        private ProcessInfo process;

        public Builder at(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder os(OsInfo os) {
            this.os = os;
            return this;
        }

        public Builder jvm(JvmInfo jvm) {
            this.jvm = jvm;
            return this;
        }

        public Builder process(ProcessInfo process) {
            this.process = process;
            return this;
        }

        public Monitor build() {
            Monitor metrics = new Monitor(this.timestamp);
            metrics.os = this.os;
            metrics.jvm = this.jvm;
            metrics.process = this.process;
            return metrics;
        }
    }
}

