/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.reporter.api.v4.metric;

import io.gravitee.common.http.HttpMethod;
import io.gravitee.reporter.api.AbstractReportable;
import io.gravitee.reporter.api.http.SecurityType;
import io.gravitee.reporter.api.log.Log;
import java.util.HashMap;
import java.util.Map;

public class Metrics
extends AbstractReportable {
    private boolean enabled;
    private String requestId;
    private String transactionId;
    private String apiId;
    private String apiType;
    private String planId;
    private String applicationId;
    private String subscriptionId;
    private String clientIdentifier;
    private String tenant;
    private String zone;
    private HttpMethod httpMethod;
    private String localAddress;
    private String remoteAddress;
    private String host;
    private String uri;
    private String pathInfo;
    private String mappedPath;
    private String userAgent;
    private long requestContentLength;
    private boolean requestEnded;
    private String endpoint;
    private long endpointResponseTimeMs;
    private int status;
    private long responseContentLength;
    private long gatewayResponseTimeMs;
    private long gatewayLatencyMs;
    private String user;
    private SecurityType securityType;
    private String securityToken;
    private String errorMessage;
    private String errorKey;
    private Map<String, String> customMetrics;
    private io.gravitee.reporter.api.v4.log.Log log;

    public void addCustomMetric(String key, String value) {
        if (this.customMetrics == null) {
            this.customMetrics = new HashMap<String, String>();
        }
        this.customMetrics.put(key, value);
    }

    public io.gravitee.reporter.api.http.Metrics toV2() {
        io.gravitee.reporter.api.http.Metrics metricsV2 = io.gravitee.reporter.api.http.Metrics.on(this.getTimestamp()).build();
        metricsV2.setProxyResponseTimeMs(this.gatewayResponseTimeMs);
        metricsV2.setProxyLatencyMs(this.gatewayLatencyMs);
        metricsV2.setApiResponseTimeMs(this.endpointResponseTimeMs);
        metricsV2.setRequestId(this.requestId);
        metricsV2.setApi(this.apiId);
        metricsV2.setApplication(this.applicationId);
        metricsV2.setTransactionId(this.transactionId);
        metricsV2.setClientIdentifier(this.clientIdentifier);
        metricsV2.setTenant(this.tenant);
        metricsV2.setMessage(this.errorMessage);
        metricsV2.setPlan(this.planId);
        metricsV2.setLocalAddress(this.localAddress);
        metricsV2.setRemoteAddress(this.remoteAddress);
        metricsV2.setHttpMethod(this.httpMethod);
        metricsV2.setHost(this.host);
        metricsV2.setUri(this.uri);
        metricsV2.setRequestContentLength(this.requestContentLength);
        metricsV2.setResponseContentLength(this.responseContentLength);
        metricsV2.setStatus(this.status);
        metricsV2.setEndpoint(this.endpoint);
        if (this.log != null) {
            Log logV2 = new Log(this.log.getTimestamp());
            logV2.setRequestId(this.log.getRequestId());
            logV2.setApi(this.log.getApiId());
            logV2.setClientRequest(this.log.getEntrypointRequest());
            logV2.setClientResponse(this.log.getEntrypointResponse());
            logV2.setProxyRequest(this.log.getEndpointRequest());
            logV2.setProxyResponse(this.log.getEndpointResponse());
            metricsV2.setLog(logV2);
        }
        metricsV2.setPath(this.pathInfo);
        metricsV2.setMappedPath(this.mappedPath);
        metricsV2.setUserAgent(this.userAgent);
        metricsV2.setUser(this.user);
        metricsV2.setSecurityType(this.securityType);
        metricsV2.setSecurityToken(this.securityToken);
        metricsV2.setErrorKey(this.errorKey);
        metricsV2.setSubscription(this.subscriptionId);
        metricsV2.setZone(this.zone);
        metricsV2.setCustomMetrics(this.customMetrics);
        return metricsV2;
    }

    private static boolean $default$enabled() {
        return true;
    }

    private static long $default$requestContentLength() {
        return -1L;
    }

    private static long $default$endpointResponseTimeMs() {
        return -1L;
    }

    private static long $default$responseContentLength() {
        return -1L;
    }

    private static long $default$gatewayResponseTimeMs() {
        return -1L;
    }

    private static long $default$gatewayLatencyMs() {
        return -1L;
    }

    protected Metrics(MetricsBuilder<?, ?> b) {
        super(b);
        this.enabled = b.enabled$set ? b.enabled$value : Metrics.$default$enabled();
        this.requestId = b.requestId;
        this.transactionId = b.transactionId;
        this.apiId = b.apiId;
        this.apiType = b.apiType;
        this.planId = b.planId;
        this.applicationId = b.applicationId;
        this.subscriptionId = b.subscriptionId;
        this.clientIdentifier = b.clientIdentifier;
        this.tenant = b.tenant;
        this.zone = b.zone;
        this.httpMethod = b.httpMethod;
        this.localAddress = b.localAddress;
        this.remoteAddress = b.remoteAddress;
        this.host = b.host;
        this.uri = b.uri;
        this.pathInfo = b.pathInfo;
        this.mappedPath = b.mappedPath;
        this.userAgent = b.userAgent;
        this.requestContentLength = b.requestContentLength$set ? b.requestContentLength$value : Metrics.$default$requestContentLength();
        this.requestEnded = b.requestEnded;
        this.endpoint = b.endpoint;
        this.endpointResponseTimeMs = b.endpointResponseTimeMs$set ? b.endpointResponseTimeMs$value : Metrics.$default$endpointResponseTimeMs();
        this.status = b.status;
        this.responseContentLength = b.responseContentLength$set ? b.responseContentLength$value : Metrics.$default$responseContentLength();
        this.gatewayResponseTimeMs = b.gatewayResponseTimeMs$set ? b.gatewayResponseTimeMs$value : Metrics.$default$gatewayResponseTimeMs();
        this.gatewayLatencyMs = b.gatewayLatencyMs$set ? b.gatewayLatencyMs$value : Metrics.$default$gatewayLatencyMs();
        this.user = b.user;
        this.securityType = b.securityType;
        this.securityToken = b.securityToken;
        this.errorMessage = b.errorMessage;
        this.errorKey = b.errorKey;
        this.customMetrics = b.customMetrics;
        this.log = b.log;
    }

    public static MetricsBuilder<?, ?> builder() {
        return new MetricsBuilderImpl();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public String getApiId() {
        return this.apiId;
    }

    public String getApiType() {
        return this.apiType;
    }

    public String getPlanId() {
        return this.planId;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public String getClientIdentifier() {
        return this.clientIdentifier;
    }

    public String getTenant() {
        return this.tenant;
    }

    public String getZone() {
        return this.zone;
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public String getLocalAddress() {
        return this.localAddress;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public String getHost() {
        return this.host;
    }

    public String getUri() {
        return this.uri;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getMappedPath() {
        return this.mappedPath;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public long getRequestContentLength() {
        return this.requestContentLength;
    }

    public boolean isRequestEnded() {
        return this.requestEnded;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public long getEndpointResponseTimeMs() {
        return this.endpointResponseTimeMs;
    }

    public int getStatus() {
        return this.status;
    }

    public long getResponseContentLength() {
        return this.responseContentLength;
    }

    public long getGatewayResponseTimeMs() {
        return this.gatewayResponseTimeMs;
    }

    public long getGatewayLatencyMs() {
        return this.gatewayLatencyMs;
    }

    public String getUser() {
        return this.user;
    }

    public SecurityType getSecurityType() {
        return this.securityType;
    }

    public String getSecurityToken() {
        return this.securityToken;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getErrorKey() {
        return this.errorKey;
    }

    public Map<String, String> getCustomMetrics() {
        return this.customMetrics;
    }

    public io.gravitee.reporter.api.v4.log.Log getLog() {
        return this.log;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public void setApiId(String apiId) {
        this.apiId = apiId;
    }

    public void setApiType(String apiType) {
        this.apiType = apiType;
    }

    public void setPlanId(String planId) {
        this.planId = planId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public void setSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
    }

    public void setClientIdentifier(String clientIdentifier) {
        this.clientIdentifier = clientIdentifier;
    }

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    public void setZone(String zone) {
        this.zone = zone;
    }

    public void setHttpMethod(HttpMethod httpMethod) {
        this.httpMethod = httpMethod;
    }

    public void setLocalAddress(String localAddress) {
        this.localAddress = localAddress;
    }

    public void setRemoteAddress(String remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void setPathInfo(String pathInfo) {
        this.pathInfo = pathInfo;
    }

    public void setMappedPath(String mappedPath) {
        this.mappedPath = mappedPath;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public void setRequestContentLength(long requestContentLength) {
        this.requestContentLength = requestContentLength;
    }

    public void setRequestEnded(boolean requestEnded) {
        this.requestEnded = requestEnded;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public void setEndpointResponseTimeMs(long endpointResponseTimeMs) {
        this.endpointResponseTimeMs = endpointResponseTimeMs;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setResponseContentLength(long responseContentLength) {
        this.responseContentLength = responseContentLength;
    }

    public void setGatewayResponseTimeMs(long gatewayResponseTimeMs) {
        this.gatewayResponseTimeMs = gatewayResponseTimeMs;
    }

    public void setGatewayLatencyMs(long gatewayLatencyMs) {
        this.gatewayLatencyMs = gatewayLatencyMs;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setSecurityType(SecurityType securityType) {
        this.securityType = securityType;
    }

    public void setSecurityToken(String securityToken) {
        this.securityToken = securityToken;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public void setErrorKey(String errorKey) {
        this.errorKey = errorKey;
    }

    public void setCustomMetrics(Map<String, String> customMetrics) {
        this.customMetrics = customMetrics;
    }

    public void setLog(io.gravitee.reporter.api.v4.log.Log log) {
        this.log = log;
    }

    public Metrics() {
        this.enabled = Metrics.$default$enabled();
        this.requestContentLength = Metrics.$default$requestContentLength();
        this.endpointResponseTimeMs = Metrics.$default$endpointResponseTimeMs();
        this.responseContentLength = Metrics.$default$responseContentLength();
        this.gatewayResponseTimeMs = Metrics.$default$gatewayResponseTimeMs();
        this.gatewayLatencyMs = Metrics.$default$gatewayLatencyMs();
    }

    public Metrics(boolean enabled, String requestId, String transactionId, String apiId, String apiType, String planId, String applicationId, String subscriptionId, String clientIdentifier, String tenant, String zone, HttpMethod httpMethod, String localAddress, String remoteAddress, String host, String uri, String pathInfo, String mappedPath, String userAgent, long requestContentLength, boolean requestEnded, String endpoint, long endpointResponseTimeMs, int status, long responseContentLength, long gatewayResponseTimeMs, long gatewayLatencyMs, String user, SecurityType securityType, String securityToken, String errorMessage, String errorKey, Map<String, String> customMetrics, io.gravitee.reporter.api.v4.log.Log log) {
        this.enabled = enabled;
        this.requestId = requestId;
        this.transactionId = transactionId;
        this.apiId = apiId;
        this.apiType = apiType;
        this.planId = planId;
        this.applicationId = applicationId;
        this.subscriptionId = subscriptionId;
        this.clientIdentifier = clientIdentifier;
        this.tenant = tenant;
        this.zone = zone;
        this.httpMethod = httpMethod;
        this.localAddress = localAddress;
        this.remoteAddress = remoteAddress;
        this.host = host;
        this.uri = uri;
        this.pathInfo = pathInfo;
        this.mappedPath = mappedPath;
        this.userAgent = userAgent;
        this.requestContentLength = requestContentLength;
        this.requestEnded = requestEnded;
        this.endpoint = endpoint;
        this.endpointResponseTimeMs = endpointResponseTimeMs;
        this.status = status;
        this.responseContentLength = responseContentLength;
        this.gatewayResponseTimeMs = gatewayResponseTimeMs;
        this.gatewayLatencyMs = gatewayLatencyMs;
        this.user = user;
        this.securityType = securityType;
        this.securityToken = securityToken;
        this.errorMessage = errorMessage;
        this.errorKey = errorKey;
        this.customMetrics = customMetrics;
        this.log = log;
    }

    private static final class MetricsBuilderImpl
    extends MetricsBuilder<Metrics, MetricsBuilderImpl> {
        private MetricsBuilderImpl() {
        }

        @Override
        protected MetricsBuilderImpl self() {
            return this;
        }

        @Override
        public Metrics build() {
            return new Metrics(this);
        }
    }

    public static abstract class MetricsBuilder<C extends Metrics, B extends MetricsBuilder<C, B>>
    extends AbstractReportable.AbstractReportableBuilder<C, B> {
        private boolean enabled$set;
        private boolean enabled$value;
        private String requestId;
        private String transactionId;
        private String apiId;
        private String apiType;
        private String planId;
        private String applicationId;
        private String subscriptionId;
        private String clientIdentifier;
        private String tenant;
        private String zone;
        private HttpMethod httpMethod;
        private String localAddress;
        private String remoteAddress;
        private String host;
        private String uri;
        private String pathInfo;
        private String mappedPath;
        private String userAgent;
        private boolean requestContentLength$set;
        private long requestContentLength$value;
        private boolean requestEnded;
        private String endpoint;
        private boolean endpointResponseTimeMs$set;
        private long endpointResponseTimeMs$value;
        private int status;
        private boolean responseContentLength$set;
        private long responseContentLength$value;
        private boolean gatewayResponseTimeMs$set;
        private long gatewayResponseTimeMs$value;
        private boolean gatewayLatencyMs$set;
        private long gatewayLatencyMs$value;
        private String user;
        private SecurityType securityType;
        private String securityToken;
        private String errorMessage;
        private String errorKey;
        private Map<String, String> customMetrics;
        private io.gravitee.reporter.api.v4.log.Log log;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B enabled(boolean enabled) {
            this.enabled$value = enabled;
            this.enabled$set = true;
            return (B)this.self();
        }

        public B requestId(String requestId) {
            this.requestId = requestId;
            return (B)this.self();
        }

        public B transactionId(String transactionId) {
            this.transactionId = transactionId;
            return (B)this.self();
        }

        public B apiId(String apiId) {
            this.apiId = apiId;
            return (B)this.self();
        }

        public B apiType(String apiType) {
            this.apiType = apiType;
            return (B)this.self();
        }

        public B planId(String planId) {
            this.planId = planId;
            return (B)this.self();
        }

        public B applicationId(String applicationId) {
            this.applicationId = applicationId;
            return (B)this.self();
        }

        public B subscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
            return (B)this.self();
        }

        public B clientIdentifier(String clientIdentifier) {
            this.clientIdentifier = clientIdentifier;
            return (B)this.self();
        }

        public B tenant(String tenant) {
            this.tenant = tenant;
            return (B)this.self();
        }

        public B zone(String zone) {
            this.zone = zone;
            return (B)this.self();
        }

        public B httpMethod(HttpMethod httpMethod) {
            this.httpMethod = httpMethod;
            return (B)this.self();
        }

        public B localAddress(String localAddress) {
            this.localAddress = localAddress;
            return (B)this.self();
        }

        public B remoteAddress(String remoteAddress) {
            this.remoteAddress = remoteAddress;
            return (B)this.self();
        }

        public B host(String host) {
            this.host = host;
            return (B)this.self();
        }

        public B uri(String uri) {
            this.uri = uri;
            return (B)this.self();
        }

        public B pathInfo(String pathInfo) {
            this.pathInfo = pathInfo;
            return (B)this.self();
        }

        public B mappedPath(String mappedPath) {
            this.mappedPath = mappedPath;
            return (B)this.self();
        }

        public B userAgent(String userAgent) {
            this.userAgent = userAgent;
            return (B)this.self();
        }

        public B requestContentLength(long requestContentLength) {
            this.requestContentLength$value = requestContentLength;
            this.requestContentLength$set = true;
            return (B)this.self();
        }

        public B requestEnded(boolean requestEnded) {
            this.requestEnded = requestEnded;
            return (B)this.self();
        }

        public B endpoint(String endpoint) {
            this.endpoint = endpoint;
            return (B)this.self();
        }

        public B endpointResponseTimeMs(long endpointResponseTimeMs) {
            this.endpointResponseTimeMs$value = endpointResponseTimeMs;
            this.endpointResponseTimeMs$set = true;
            return (B)this.self();
        }

        public B status(int status) {
            this.status = status;
            return (B)this.self();
        }

        public B responseContentLength(long responseContentLength) {
            this.responseContentLength$value = responseContentLength;
            this.responseContentLength$set = true;
            return (B)this.self();
        }

        public B gatewayResponseTimeMs(long gatewayResponseTimeMs) {
            this.gatewayResponseTimeMs$value = gatewayResponseTimeMs;
            this.gatewayResponseTimeMs$set = true;
            return (B)this.self();
        }

        public B gatewayLatencyMs(long gatewayLatencyMs) {
            this.gatewayLatencyMs$value = gatewayLatencyMs;
            this.gatewayLatencyMs$set = true;
            return (B)this.self();
        }

        public B user(String user) {
            this.user = user;
            return (B)this.self();
        }

        public B securityType(SecurityType securityType) {
            this.securityType = securityType;
            return (B)this.self();
        }

        public B securityToken(String securityToken) {
            this.securityToken = securityToken;
            return (B)this.self();
        }

        public B errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return (B)this.self();
        }

        public B errorKey(String errorKey) {
            this.errorKey = errorKey;
            return (B)this.self();
        }

        public B customMetrics(Map<String, String> customMetrics) {
            this.customMetrics = customMetrics;
            return (B)this.self();
        }

        public B log(io.gravitee.reporter.api.v4.log.Log log) {
            this.log = log;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "Metrics.MetricsBuilder(super=" + super.toString() + ", enabled$value=" + this.enabled$value + ", requestId=" + this.requestId + ", transactionId=" + this.transactionId + ", apiId=" + this.apiId + ", apiType=" + this.apiType + ", planId=" + this.planId + ", applicationId=" + this.applicationId + ", subscriptionId=" + this.subscriptionId + ", clientIdentifier=" + this.clientIdentifier + ", tenant=" + this.tenant + ", zone=" + this.zone + ", httpMethod=" + this.httpMethod + ", localAddress=" + this.localAddress + ", remoteAddress=" + this.remoteAddress + ", host=" + this.host + ", uri=" + this.uri + ", pathInfo=" + this.pathInfo + ", mappedPath=" + this.mappedPath + ", userAgent=" + this.userAgent + ", requestContentLength$value=" + this.requestContentLength$value + ", requestEnded=" + this.requestEnded + ", endpoint=" + this.endpoint + ", endpointResponseTimeMs$value=" + this.endpointResponseTimeMs$value + ", status=" + this.status + ", responseContentLength$value=" + this.responseContentLength$value + ", gatewayResponseTimeMs$value=" + this.gatewayResponseTimeMs$value + ", gatewayLatencyMs$value=" + this.gatewayLatencyMs$value + ", user=" + this.user + ", securityType=" + this.securityType + ", securityToken=" + this.securityToken + ", errorMessage=" + this.errorMessage + ", errorKey=" + this.errorKey + ", customMetrics=" + this.customMetrics + ", log=" + this.log + ")";
        }
    }
}

