/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.reporter.elasticsearch;

import io.gravitee.elasticsearch.version.ElasticsearchInfo;
import io.gravitee.reporter.elasticsearch.config.ReporterConfiguration;
import io.gravitee.reporter.elasticsearch.spring.context.AbstractElasticBeanRegistrer;
import io.gravitee.reporter.elasticsearch.spring.context.Elastic7xBeanRegistrer;
import io.gravitee.reporter.elasticsearch.spring.context.Elastic8xBeanRegistrer;
import io.gravitee.reporter.elasticsearch.spring.context.OpenSearchBeanRegistrer;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;

public class BeanRegister {
    private static final Logger log = LoggerFactory.getLogger(BeanRegister.class);
    private final ApplicationContext applicationContext;
    private static final Set<Integer> SUPPORTED_OPENSEARCH_MAJOR_VERSIONS = Set.of(Integer.valueOf(1), Integer.valueOf(2));

    public BeanRegister(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public boolean registerBeans(ElasticsearchInfo info, ReporterConfiguration configuration) {
        AbstractElasticBeanRegistrer elasticsearchBeanRegister = this.getBeanRegistrerFromElasticsearchInfo(info);
        if (elasticsearchBeanRegister == null) {
            log.error("{} version {} is not supported by this connector", (Object)(info.getVersion().isOpenSearch() ? "OpenSearch" : "ElasticSearch"), (Object)info.getVersion().getNumber());
            return false;
        }
        DefaultListableBeanFactory factory = (DefaultListableBeanFactory)this.applicationContext.getAutowireCapableBeanFactory();
        elasticsearchBeanRegister.register((BeanDefinitionRegistry)factory, configuration);
        return true;
    }

    private AbstractElasticBeanRegistrer getBeanRegistrerFromElasticsearchInfo(ElasticsearchInfo elasticsearchInfo) {
        if (elasticsearchInfo.getVersion().isOpenSearch()) {
            if (SUPPORTED_OPENSEARCH_MAJOR_VERSIONS.contains(elasticsearchInfo.getVersion().getMajorVersion())) {
                return new OpenSearchBeanRegistrer();
            }
            return null;
        }
        switch (elasticsearchInfo.getVersion().getMajorVersion()) {
            case 7: {
                return new Elastic7xBeanRegistrer();
            }
            case 8: {
                return new Elastic8xBeanRegistrer();
            }
        }
        return null;
    }
}

