/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.reporter.elasticsearch;

import io.gravitee.common.service.AbstractService;
import io.gravitee.elasticsearch.client.Client;
import io.gravitee.elasticsearch.version.ElasticsearchInfo;
import io.gravitee.reporter.api.Reportable;
import io.gravitee.reporter.api.Reporter;
import io.gravitee.reporter.api.health.EndpointStatus;
import io.gravitee.reporter.api.http.Metrics;
import io.gravitee.reporter.api.monitor.Monitor;
import io.gravitee.reporter.api.v4.log.Log;
import io.gravitee.reporter.api.v4.log.MessageLog;
import io.gravitee.reporter.api.v4.metric.MessageMetrics;
import io.gravitee.reporter.elasticsearch.BeanRegister;
import io.gravitee.reporter.elasticsearch.config.ReporterConfiguration;
import io.gravitee.reporter.elasticsearch.indexer.Indexer;
import io.gravitee.reporter.elasticsearch.mapping.IndexPreparer;
import io.reactivex.rxjava3.core.BackpressureStrategy;
import io.reactivex.rxjava3.core.CompletableObserver;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.disposables.Disposable;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ElasticsearchReporter
extends AbstractService<Reporter>
implements Reporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticsearchReporter.class);
    @Autowired
    private Client client;
    @Autowired
    private ReporterConfiguration configuration;
    private Indexer indexer;

    protected void doStart() throws Exception {
        if (this.configuration.isEnabled()) {
            super.doStart();
            LOGGER.info("Starting Elastic reporter engine...");
            BeanRegister beanRegister = new BeanRegister(this.applicationContext);
            if (!beanRegister.registerBeans(this.retrieveElasticSearchInfo(), this.configuration)) {
                LOGGER.info("Starting Elastic reporter engine... ERROR");
                return;
            }
            IndexPreparer preparer = (IndexPreparer)this.applicationContext.getBean(IndexPreparer.class);
            preparer.prepare().doOnComplete(() -> LOGGER.info("Starting Elastic reporter engine... DONE")).subscribe(new CompletableObserver(){

                public void onSubscribe(Disposable d) {
                }

                public void onComplete() {
                    LOGGER.info("Index mapping template successfully defined");
                }

                public void onError(Throwable t) {
                    LOGGER.error("An error occurs while creating index mapping template", t);
                }
            });
            this.indexer = (Indexer)this.applicationContext.getBean(Indexer.class);
        }
    }

    public void report(Reportable reportable) {
        if (this.configuration.isEnabled()) {
            this.indexer.index(reportable);
        }
    }

    Single<Reportable> rxReport(Reportable reportable) {
        this.indexer.index(reportable);
        return Single.just((Object)reportable);
    }

    public boolean canHandle(Reportable reportable) {
        return reportable instanceof Metrics || reportable instanceof EndpointStatus || reportable instanceof Monitor || reportable instanceof io.gravitee.reporter.api.log.Log || reportable instanceof io.gravitee.reporter.api.v4.metric.Metrics || reportable instanceof MessageMetrics || reportable instanceof Log || reportable instanceof MessageLog;
    }

    protected void doStop() throws Exception {
        if (this.configuration.isEnabled()) {
            super.doStop();
            LOGGER.info("Stopping Elastic reporter engine... DONE");
        }
    }

    private ElasticsearchInfo retrieveElasticSearchInfo() {
        Single elasticsearchInfoSingle = this.client.getInfo().retryWhen(error -> error.flatMap(throwable -> Observable.just((Object)new Object()).delay(5L, TimeUnit.SECONDS).toFlowable(BackpressureStrategy.LATEST)));
        elasticsearchInfoSingle.subscribe();
        return (ElasticsearchInfo)elasticsearchInfoSingle.blockingGet();
    }
}

