/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.reporter.elasticsearch.config;

import io.gravitee.common.templating.FreeMarkerComponent;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PipelineConfiguration {
    private static final List<String> RETAINED_INGEST_PLUGINS = Arrays.asList("geoip", "user_agent", "gravitee");
    private final String ingestPlugins;
    private final String userAgentRegexFile;
    private final FreeMarkerComponent freeMarkerComponent;
    private final String pipeline = "gravitee_pipeline";
    private boolean valid = false;

    public PipelineConfiguration(String ingestPlugins, String userAgentRegexFile, FreeMarkerComponent freeMarkerComponent) {
        this.ingestPlugins = ingestPlugins;
        this.userAgentRegexFile = userAgentRegexFile;
        this.freeMarkerComponent = freeMarkerComponent;
    }

    public String createPipeline() {
        if (this.ingestPlugins != null && !this.ingestPlugins.isEmpty()) {
            Set configuredPlugin = Stream.of(this.ingestPlugins.split(",")).map(String::trim).collect(Collectors.toSet());
            configuredPlugin.retainAll(RETAINED_INGEST_PLUGINS);
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("userAgentRegexFile", this.userAgentRegexFile);
            String processors = configuredPlugin.stream().map(ingestPlug -> this.freeMarkerComponent.generateFromTemplate(ingestPlug + ".ftl", data)).collect(Collectors.joining(","));
            HashMap<String, String> processorsMap = new HashMap<String, String>(1);
            processorsMap.put("processors", processors);
            return this.freeMarkerComponent.generateFromTemplate("pipeline.ftl", processorsMap);
        }
        return null;
    }

    public String getPipelineName() {
        return this.pipeline;
    }

    public String getPipeline() {
        return this.valid ? this.pipeline : null;
    }

    public void valid() {
        this.valid = true;
    }
}

