/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.reporter.elasticsearch.config;

import io.gravitee.common.util.EnvironmentUtils;
import io.gravitee.elasticsearch.config.Endpoint;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.ConfigurableEnvironment;

public class ReporterConfiguration {
    private static final String DEFAULT_ELASTICSEARCH_ENDPOINT = "http://localhost:9200";
    @Autowired
    private ConfigurableEnvironment environment;
    @Value(value="${reporters.elasticsearch.index:gravitee}")
    private String indexName;
    @Value(value="${reporters.elasticsearch.index_per_type:false}")
    private boolean perTypeIndex;
    @Value(value="${reporters.elasticsearch.index_mode:daily}")
    private String indexMode;
    @Value(value="${reporters.elasticsearch.bulk.actions:1000}")
    private Integer bulkActions;
    @Value(value="${reporters.elasticsearch.bulk.flush_interval:5}")
    private Long flushInterval;
    @Value(value="${reporters.elasticsearch.security.username:#{null}}")
    private String username;
    @Value(value="${reporters.elasticsearch.security.password:#{null}}")
    private String password;
    @Value(value="${reporters.elasticsearch.ssl.keystore.type:#{null}}")
    private String sslKeystoreType;
    @Value(value="${reporters.elasticsearch.ssl.keystore.path:#{null}}")
    private String sslKeystore;
    @Value(value="${reporters.elasticsearch.ssl.keystore.password:#{null}}")
    private String sslKeystorePassword;
    private List<String> sslPemCerts;
    private List<String> sslPemKeys;
    @Value(value="${reporters.elasticsearch.http.timeout:30000}")
    private long requestTimeout;
    @Value(value="${reporters.elasticsearch.http.proxy.type:HTTP}")
    private String proxyType;
    @Value(value="${reporters.elasticsearch.http.proxy.http.host:#{systemProperties['http.proxyHost'] ?: 'localhost'}}")
    private String proxyHttpHost;
    @Value(value="${reporters.elasticsearch.http.proxy.http.port:#{systemProperties['http.proxyPort'] ?: 3128}}")
    private int proxyHttpPort;
    @Value(value="${reporters.elasticsearch.http.proxy.http.username:#{null}}")
    private String proxyHttpUsername;
    @Value(value="${reporters.elasticsearch.http.proxy.http.password:#{null}}")
    private String proxyHttpPassword;
    @Value(value="${reporters.elasticsearch.http.proxy.https.host:#{systemProperties['https.proxyHost'] ?: 'localhost'}}")
    private String proxyHttpsHost;
    @Value(value="${reporters.elasticsearch.http.proxy.https.port:#{systemProperties['https.proxyPort'] ?: 3128}}")
    private int proxyHttpsPort;
    @Value(value="${reporters.elasticsearch.http.proxy.https.username:#{null}}")
    private String proxyHttpsUsername;
    @Value(value="${reporters.elasticsearch.http.proxy.https.password:#{null}}")
    private String proxyHttpsPassword;
    @Value(value="${reporters.elasticsearch.settings.number_of_shards:1}")
    private int numberOfShards;
    @Value(value="${reporters.elasticsearch.settings.number_of_replicas:1}")
    private int numberOfReplicas;
    @Value(value="${reporters.elasticsearch.settings.refresh_interval:5s}")
    private String refreshInterval;
    @Value(value="${reporters.elasticsearch.enabled:true}")
    private boolean enabled;
    private List<Endpoint> endpoints;
    @Value(value="${reporters.elasticsearch.template_mapping.extended_request_mapping:#{null}}")
    private String extendedRequestMappingTemplate;
    @Value(value="${reporters.elasticsearch.lifecycle.policies.monitor:#{null}}")
    private String indexLifecyclePolicyMonitor;
    @Value(value="${reporters.elasticsearch.lifecycle.policies.health:#{null}}")
    private String indexLifecyclePolicyHealth;
    @Value(value="${reporters.elasticsearch.lifecycle.policies.request:#{null}}")
    private String indexLifecyclePolicyRequest;
    @Value(value="${reporters.elasticsearch.lifecycle.policies.log:#{null}}")
    private String indexLifecyclePolicyLog;
    @Value(value="${reporters.elasticsearch.lifecycle.policy_property_name:index.lifecycle.name}")
    private String indexLifecyclePolicyPropertyName;
    @Value(value="${reporters.elasticsearch.template_mapping.extended_settings:#{null}}")
    private String extendedSettingsTemplate;

    public List<Endpoint> getEndpoints() {
        if (this.endpoints == null) {
            this.endpoints = this.initializeEndpoints();
        }
        return this.endpoints;
    }

    public void setEndpoints(List<Endpoint> endpoints) {
        this.endpoints = endpoints;
    }

    public Integer getBulkActions() {
        return this.bulkActions;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public void setBulkActions(Integer bulkActions) {
        this.bulkActions = bulkActions;
    }

    public void setFlushInterval(Long flushInterval) {
        this.flushInterval = flushInterval;
    }

    public Long getFlushInterval() {
        return this.flushInterval;
    }

    public String getIndexName() {
        return this.indexName;
    }

    private List<Endpoint> initializeEndpoints() {
        String key = String.format("reporters.elasticsearch.endpoints[%s]", 0);
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        while (this.environment.containsProperty(key)) {
            String url = this.environment.getProperty(key);
            endpoints.add(new Endpoint(url));
            key = String.format("reporters.elasticsearch.endpoints[%s]", endpoints.size());
        }
        if (endpoints.isEmpty()) {
            endpoints.add(new Endpoint(DEFAULT_ELASTICSEARCH_ENDPOINT));
        }
        return endpoints;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getSslKeystoreType() {
        return this.sslKeystoreType;
    }

    public void setSslKeystoreType(String sslKeystoreType) {
        this.sslKeystoreType = sslKeystoreType;
    }

    public String getSslKeystore() {
        return this.sslKeystore;
    }

    public void setSslKeystore(String sslKeystore) {
        this.sslKeystore = sslKeystore;
    }

    public String getSslKeystorePassword() {
        return this.sslKeystorePassword;
    }

    public void setSslKeystorePassword(String sslKeystorePassword) {
        this.sslKeystorePassword = sslKeystorePassword;
    }

    public List<String> getSslPemCerts() {
        if (this.sslPemCerts == null) {
            this.sslPemCerts = this.readPropertyAsList("reporters.elasticsearch.ssl.keystore.certs");
        }
        return this.sslPemCerts;
    }

    public void setSslPemCerts(List<String> sslPemCerts) {
        this.sslPemCerts = sslPemCerts;
    }

    public List<String> getSslPemKeys() {
        if (this.sslPemKeys == null) {
            this.sslPemKeys = this.readPropertyAsList("reporters.elasticsearch.ssl.keystore.keys");
        }
        return this.sslPemKeys;
    }

    public void setSslPemKeys(List<String> sslPemKeys) {
        this.sslPemKeys = sslPemKeys;
    }

    public int getNumberOfShards() {
        return this.numberOfShards;
    }

    public void setNumberOfShards(int numberOfShards) {
        this.numberOfShards = numberOfShards;
    }

    public int getNumberOfReplicas() {
        return this.numberOfReplicas;
    }

    public void setNumberOfReplicas(int numberOfReplicas) {
        this.numberOfReplicas = numberOfReplicas;
    }

    public String getRefreshInterval() {
        return this.refreshInterval;
    }

    public void setRefreshInterval(String refreshInterval) {
        this.refreshInterval = refreshInterval;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isPerTypeIndex() {
        return this.perTypeIndex;
    }

    public void setPerTypeIndex(boolean perTypeIndex) {
        this.perTypeIndex = perTypeIndex;
    }

    public long getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setRequestTimeout(long requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public String getExtendedRequestMappingTemplate() {
        return this.extendedRequestMappingTemplate;
    }

    public void setExtendedRequestMappingTemplate(String extendedRequestMappingTemplate) {
        this.extendedRequestMappingTemplate = extendedRequestMappingTemplate;
    }

    public String getIndexLifecyclePolicyMonitor() {
        return this.indexLifecyclePolicyMonitor;
    }

    public void setIndexLifecyclePolicyMonitor(String indexLifecyclePolicyMonitor) {
        this.indexLifecyclePolicyMonitor = indexLifecyclePolicyMonitor;
    }

    public String getIndexLifecyclePolicyHealth() {
        return this.indexLifecyclePolicyHealth;
    }

    public void setIndexLifecyclePolicyHealth(String indexLifecyclePolicyHealth) {
        this.indexLifecyclePolicyHealth = indexLifecyclePolicyHealth;
    }

    public String getIndexLifecyclePolicyRequest() {
        return this.indexLifecyclePolicyRequest;
    }

    public void setIndexLifecyclePolicyRequest(String indexLifecyclePolicyRequest) {
        this.indexLifecyclePolicyRequest = indexLifecyclePolicyRequest;
    }

    public String getIndexLifecyclePolicyLog() {
        return this.indexLifecyclePolicyLog;
    }

    public void setIndexLifecyclePolicyLog(String indexLifecyclePolicyLog) {
        this.indexLifecyclePolicyLog = indexLifecyclePolicyLog;
    }

    public String getIndexLifecyclePolicyPropertyName() {
        return this.indexLifecyclePolicyPropertyName;
    }

    public void setIndexLifecyclePolicyPropertyName(String indexLifecyclePolicyPropertyName) {
        this.indexLifecyclePolicyPropertyName = indexLifecyclePolicyPropertyName;
    }

    public String getProxyType() {
        return this.proxyType;
    }

    public void setProxyType(String proxyType) {
        this.proxyType = proxyType;
    }

    public String getProxyHttpHost() {
        return this.proxyHttpHost;
    }

    public void setProxyHttpHost(String proxyHttpHost) {
        this.proxyHttpHost = proxyHttpHost;
    }

    public int getProxyHttpPort() {
        return this.proxyHttpPort;
    }

    public void setProxyHttpPort(int proxyHttpPort) {
        this.proxyHttpPort = proxyHttpPort;
    }

    public String getProxyHttpUsername() {
        return this.proxyHttpUsername;
    }

    public void setProxyHttpUsername(String proxyHttpUsername) {
        this.proxyHttpUsername = proxyHttpUsername;
    }

    public String getProxyHttpPassword() {
        return this.proxyHttpPassword;
    }

    public void setProxyHttpPassword(String proxyHttpPassword) {
        this.proxyHttpPassword = proxyHttpPassword;
    }

    public String getProxyHttpsHost() {
        return this.proxyHttpsHost;
    }

    public void setProxyHttpsHost(String proxyHttpsHost) {
        this.proxyHttpsHost = proxyHttpsHost;
    }

    public int getProxyHttpsPort() {
        return this.proxyHttpsPort;
    }

    public void setProxyHttpsPort(int proxyHttpsPort) {
        this.proxyHttpsPort = proxyHttpsPort;
    }

    public String getProxyHttpsUsername() {
        return this.proxyHttpsUsername;
    }

    public void setProxyHttpsUsername(String proxyHttpsUsername) {
        this.proxyHttpsUsername = proxyHttpsUsername;
    }

    public String getProxyHttpsPassword() {
        return this.proxyHttpsPassword;
    }

    public void setProxyHttpsPassword(String proxyHttpsPassword) {
        this.proxyHttpsPassword = proxyHttpsPassword;
    }

    public boolean isProxyConfigured() {
        return !EnvironmentUtils.getPropertiesStartingWith((ConfigurableEnvironment)this.environment, (String)"reporters.elasticsearch.http.proxy").isEmpty();
    }

    public String getExtendedSettingsTemplate() {
        return this.extendedSettingsTemplate;
    }

    public void setExtendedSettingsTemplate(String extendedSettingsTemplate) {
        this.extendedSettingsTemplate = extendedSettingsTemplate;
    }

    public void setIndexMode(String indexMode) {
        this.indexMode = indexMode;
    }

    public boolean isIlmManagedIndex() {
        return "ilm".equalsIgnoreCase(this.indexMode);
    }

    private List<String> readPropertyAsList(String property) {
        String key = String.format("%s[%s]", property, 0);
        ArrayList<String> properties = new ArrayList<String>();
        while (this.environment.containsProperty(key)) {
            String p = this.environment.getProperty(key);
            properties.add(p);
            key = String.format("%s[%s]", property, properties.size());
        }
        if (properties.isEmpty()) {
            properties.add(this.environment.getProperty(property));
        }
        return properties;
    }
}

