/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.reporter.elasticsearch.indexer;

import io.gravitee.elasticsearch.client.Client;
import io.gravitee.elasticsearch.model.bulk.BulkResponse;
import io.gravitee.elasticsearch.model.bulk.Failure;
import io.reactivex.rxjava3.core.Single;
import io.vertx.core.buffer.Buffer;
import java.util.List;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DocumentBulkProcessor
implements Subscriber<List<Buffer>> {
    private final Logger logger = LoggerFactory.getLogger(DocumentBulkProcessor.class);
    private Subscription subscription;
    private final Client client;

    DocumentBulkProcessor(Client client) {
        this.client = client;
    }

    public void onSubscribe(Subscription subscription) {
        this.subscription = subscription;
        subscription.request(1L);
    }

    public void onNext(List<Buffer> items) {
        try {
            this.client.bulk(items).onErrorResumeNext(t -> {
                this.logger.error("Unexpected error while indexing data", t);
                Failure failure = new Failure();
                failure.setReason(t.getMessage());
                BulkResponse bulkResponse = new BulkResponse();
                bulkResponse.setErrors(Boolean.valueOf(true));
                bulkResponse.setError(failure);
                return Single.just((Object)bulkResponse);
            }).subscribe();
        }
        catch (Exception ex) {
            this.logger.error("Unexpected error while bulking data with the ES client", (Throwable)ex);
        }
        finally {
            this.subscription.request(1L);
        }
    }

    public void onError(Throwable t) {
        this.logger.error("Unexpected error while indexing data", t);
    }

    public void onComplete() {
    }
}

