/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.reporter.elasticsearch.indexer.name;

import io.gravitee.elasticsearch.utils.Type;
import io.gravitee.reporter.api.Reportable;
import io.gravitee.reporter.api.health.EndpointStatus;
import io.gravitee.reporter.api.http.Metrics;
import io.gravitee.reporter.api.log.Log;
import io.gravitee.reporter.api.monitor.Monitor;
import io.gravitee.reporter.api.v4.log.MessageLog;
import io.gravitee.reporter.api.v4.metric.MessageMetrics;
import io.gravitee.reporter.elasticsearch.indexer.name.AbstractIndexNameGenerator;
import java.time.Instant;

public abstract class AbstractPerTypeIndexNameGenerator
extends AbstractIndexNameGenerator {
    public abstract String generate(String var1, Instant var2);

    @Override
    public String generate(Reportable reportable) {
        String type = null;
        if (reportable instanceof Metrics) {
            type = Type.REQUEST.getType();
        } else if (reportable instanceof Log) {
            type = Type.LOG.getType();
        } else if (reportable instanceof Monitor) {
            type = Type.MONITOR.getType();
        } else if (reportable instanceof EndpointStatus) {
            type = Type.HEALTH_CHECK.getType();
        } else if (reportable instanceof io.gravitee.reporter.api.v4.metric.Metrics) {
            type = Type.V4_METRICS.getType();
        } else if (reportable instanceof io.gravitee.reporter.api.v4.log.Log) {
            type = Type.V4_LOG.getType();
        } else if (reportable instanceof MessageMetrics) {
            type = Type.V4_MESSAGE_METRICS.getType();
        } else if (reportable instanceof MessageLog) {
            type = Type.V4_MESSAGE_LOG.getType();
        }
        return this.generate(type, reportable.timestamp());
    }
}

