/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.reporter.file;

import io.gravitee.common.service.AbstractService;
import io.gravitee.reporter.api.Reportable;
import io.gravitee.reporter.api.Reporter;
import io.gravitee.reporter.common.MetricsType;
import io.gravitee.reporter.common.formatter.Formatter;
import io.gravitee.reporter.common.formatter.FormatterFactory;
import io.gravitee.reporter.file.config.FileReporterConfiguration;
import io.gravitee.reporter.file.vertx.VertxFileWriter;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileReporter
extends AbstractService<Reporter>
implements Reporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileReporter.class);
    private final FileReporterConfiguration configuration;
    private final FormatterFactory formatterFactory;
    private final Vertx vertx;
    private final Map<Class<? extends Reportable>, VertxFileWriter<Reportable>> writers = new HashMap<Class<? extends Reportable>, VertxFileWriter<Reportable>>(4);

    public FileReporter(FileReporterConfiguration configuration, Vertx vertx, FormatterFactory formatterFactory) {
        this.formatterFactory = formatterFactory;
        this.configuration = configuration;
        this.vertx = vertx;
    }

    public void report(Reportable reportable) {
        this.writers.get(reportable.getClass()).write(reportable);
    }

    public boolean canHandle(Reportable reportable) {
        return this.configuration.isEnabled() && this.writers.containsKey(reportable.getClass());
    }

    protected void doStart() {
        if (this.configuration.isEnabled()) {
            for (MetricsType type : MetricsType.values()) {
                Formatter formatter = this.formatterFactory.getFormatter(this.configuration.getOutputType(), type);
                this.applicationContext.getAutowireCapableBeanFactory().autowireBean((Object)formatter);
                this.writers.put(type.getClazz(), new VertxFileWriter(this.vertx, type, formatter, this.configuration.getFilename() + "." + this.configuration.getOutputType().getExtension(), this.configuration));
            }
            Future.join(this.writers.values().stream().map(VertxFileWriter::initialize).toList()).onComplete(event -> {
                if (event.succeeded()) {
                    LOGGER.info("File reporter successfully started");
                } else {
                    LOGGER.info("An error occurs while starting file reporter", event.cause());
                }
            });
        }
    }

    protected void doStop() {
        if (this.configuration.isEnabled()) {
            Future.join(this.writers.values().stream().map(VertxFileWriter::stop).toList()).onComplete(event -> {
                if (event.succeeded()) {
                    LOGGER.info("File reporter successfully stopped");
                } else {
                    LOGGER.info("An error occurs while stopping file reporter", event.cause());
                }
            });
        }
    }
}

