/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.reporter.file.config;

import io.gravitee.common.util.EnvironmentUtils;
import io.gravitee.reporter.api.configuration.Rules;
import io.gravitee.reporter.common.MetricsType;
import io.gravitee.reporter.common.formatter.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.ConfigurableEnvironment;

public class FileReporterConfiguration {
    private static final String FILE_REPORTER_PREFIX = "reporters.file.";
    @Value(value="${reporters.file.fileName:#{systemProperties['gravitee.home']}/metrics/%s-yyyy_mm_dd}")
    private String filename;
    @Value(value="${reporters.file.output:json}")
    private String outputType;
    @Value(value="${reporters.file.flushInterval:1000}")
    private long flushInterval;
    @Value(value="${reporters.file.retainDays:0}")
    private long retainDays;
    @Autowired
    private ConfigurableEnvironment environment;
    @Value(value="${reporters.file.enabled:false}")
    private boolean enabled;

    public String getFilename() {
        return this.filename;
    }

    public Type getOutputType() {
        return this.outputType == null ? Type.JSON : Type.valueOf((String)this.outputType.toUpperCase());
    }

    public long getFlushInterval() {
        return this.flushInterval;
    }

    public long getRetainDays() {
        return this.retainDays;
    }

    public Rules getRules(MetricsType type) {
        Rules rules = new Rules();
        rules.setRenameFields(this.getMapProperties(FILE_REPORTER_PREFIX + type.getType() + ".rename"));
        rules.setExcludeFields(this.getArrayProperties(FILE_REPORTER_PREFIX + type.getType() + ".exclude"));
        rules.setIncludeFields(this.getArrayProperties(FILE_REPORTER_PREFIX + type.getType() + ".include"));
        return rules;
    }

    private Map<String, String> getMapProperties(String prefix) {
        Map properties = EnvironmentUtils.getPropertiesStartingWith((ConfigurableEnvironment)this.environment, (String)prefix);
        if (!properties.isEmpty()) {
            return properties.entrySet().stream().collect(Collectors.toMap(entry -> ((String)entry.getKey()).substring(EnvironmentUtils.encodedKey((String)prefix).length() + 1), entry -> entry.getValue().toString()));
        }
        return Collections.emptyMap();
    }

    private Set<String> getArrayProperties(String prefix) {
        HashSet<String> properties = new HashSet<String>();
        boolean found = true;
        int idx = 0;
        while (found) {
            String property;
            if (!(found = (property = this.environment.getProperty(prefix + "[" + idx++ + "]")) != null && !property.isEmpty())) continue;
            properties.add(property);
        }
        return properties;
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

