/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.reporter.common.formatter;

import io.gravitee.reporter.api.Reportable;
import io.gravitee.reporter.api.v4.metric.Metrics;
import io.gravitee.reporter.common.formatter.Formatter;
import io.vertx.core.buffer.Buffer;
import java.util.Map;
import org.apache.commons.validator.routines.InetAddressValidator;

public abstract class AbstractFormatter<T extends Reportable>
implements Formatter<T> {
    private static final String REMOTE_ADDRESS_FALLBACK = "0.0.0.0";

    @Override
    public Buffer format(T reportable) {
        return this.format(reportable, null);
    }

    @Override
    public Buffer format(T reportable, Map<String, Object> options) {
        io.gravitee.reporter.api.http.Metrics metrics;
        if (reportable instanceof io.gravitee.reporter.api.http.Metrics) {
            metrics = (io.gravitee.reporter.api.http.Metrics)reportable;
            metrics.setRemoteAddress(AbstractFormatter.sanitizeRemoteAddress(metrics.getRemoteAddress()));
        }
        if (reportable instanceof Metrics) {
            metrics = (Metrics)reportable;
            metrics.setRemoteAddress(AbstractFormatter.sanitizeRemoteAddress(metrics.getRemoteAddress()));
        }
        return options == null ? this.format0(reportable) : this.format0(reportable, options);
    }

    private static String sanitizeRemoteAddress(String remoteAddress) {
        return InetAddressValidator.getInstance().isValid(remoteAddress) ? remoteAddress : REMOTE_ADDRESS_FALLBACK;
    }

    protected abstract Buffer format0(T var1);

    protected Buffer format0(T data, Map<String, Object> options) {
        return this.format0(data);
    }
}

