/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.reporter.common.formatter;

import io.gravitee.node.api.Node;
import io.gravitee.reporter.api.Reportable;
import io.gravitee.reporter.common.MetricsType;
import io.gravitee.reporter.common.formatter.Formatter;
import io.gravitee.reporter.common.formatter.FormatterFactoryConfiguration;
import io.gravitee.reporter.common.formatter.Type;
import io.gravitee.reporter.common.formatter.csv.CsvFormatter;
import io.gravitee.reporter.common.formatter.elasticsearch.ElasticsearchFormatter;
import io.gravitee.reporter.common.formatter.elasticsearch.FreeMarkerComponent;
import io.gravitee.reporter.common.formatter.json.JsonFormatter;
import io.gravitee.reporter.common.formatter.msgpack.MsgPackFormatter;

public class FormatterFactory {
    private final Node node;
    private final FormatterFactoryConfiguration configuration;

    public FormatterFactory(Node node, FormatterFactoryConfiguration configuration) {
        this.node = node;
        this.configuration = configuration;
    }

    public Formatter<Reportable> getFormatter(Type type) {
        return this.getFormatter(type, null);
    }

    public Formatter<Reportable> getFormatter(Type type, MetricsType metricsType) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case Type.CSV -> new CsvFormatter();
            case Type.MESSAGE_PACK -> new MsgPackFormatter(this.configuration.getRules(metricsType));
            case Type.JSON -> new JsonFormatter(this.configuration.getRules(metricsType));
            case Type.ELASTICSEARCH -> new ElasticsearchFormatter(this.node, new FreeMarkerComponent(this.configuration.elasticSearchVersion));
        };
    }
}

