/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.reporter.common.formatter;

import io.gravitee.reporter.api.configuration.Rules;
import io.gravitee.reporter.common.MetricsType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class FormatterFactoryConfiguration {
    int elasticSearchVersion;
    Map<MetricsType, Rules> rules;

    public Rules getRules(MetricsType metricsType) {
        return this.rules.getOrDefault((Object)metricsType, new Rules());
    }

    private static int $default$elasticSearchVersion() {
        return 8;
    }

    FormatterFactoryConfiguration(int elasticSearchVersion, Map<MetricsType, Rules> rules) {
        this.elasticSearchVersion = elasticSearchVersion;
        this.rules = rules;
    }

    public static FormatterFactoryConfigurationBuilder builder() {
        return new FormatterFactoryConfigurationBuilder();
    }

    public static class FormatterFactoryConfigurationBuilder {
        private boolean elasticSearchVersion$set;
        private int elasticSearchVersion$value;
        private ArrayList<MetricsType> rules$key;
        private ArrayList<Rules> rules$value;

        FormatterFactoryConfigurationBuilder() {
        }

        public FormatterFactoryConfigurationBuilder elasticSearchVersion(int elasticSearchVersion) {
            this.elasticSearchVersion$value = elasticSearchVersion;
            this.elasticSearchVersion$set = true;
            return this;
        }

        public FormatterFactoryConfigurationBuilder rule(MetricsType ruleKey, Rules ruleValue) {
            if (this.rules$key == null) {
                this.rules$key = new ArrayList();
                this.rules$value = new ArrayList();
            }
            this.rules$key.add(ruleKey);
            this.rules$value.add(ruleValue);
            return this;
        }

        public FormatterFactoryConfigurationBuilder rules(Map<? extends MetricsType, ? extends Rules> rules) {
            if (rules == null) {
                throw new NullPointerException("rules cannot be null");
            }
            if (this.rules$key == null) {
                this.rules$key = new ArrayList();
                this.rules$value = new ArrayList();
            }
            for (Map.Entry<? extends MetricsType, ? extends Rules> $lombokEntry : rules.entrySet()) {
                this.rules$key.add($lombokEntry.getKey());
                this.rules$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public FormatterFactoryConfigurationBuilder clearRules() {
            if (this.rules$key != null) {
                this.rules$key.clear();
                this.rules$value.clear();
            }
            return this;
        }

        public FormatterFactoryConfiguration build() {
            Map<MetricsType, Rules> rules;
            switch (this.rules$key == null ? 0 : this.rules$key.size()) {
                case 0: {
                    rules = Collections.emptyMap();
                    break;
                }
                case 1: {
                    rules = Collections.singletonMap(this.rules$key.get(0), this.rules$value.get(0));
                    break;
                }
                default: {
                    rules = new LinkedHashMap(this.rules$key.size() < 0x40000000 ? 1 + this.rules$key.size() + (this.rules$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.rules$key.size(); ++$i) {
                        rules.put(this.rules$key.get($i), this.rules$value.get($i));
                    }
                    rules = Collections.unmodifiableMap(rules);
                }
            }
            int elasticSearchVersion$value = this.elasticSearchVersion$value;
            if (!this.elasticSearchVersion$set) {
                elasticSearchVersion$value = FormatterFactoryConfiguration.$default$elasticSearchVersion();
            }
            return new FormatterFactoryConfiguration(elasticSearchVersion$value, rules);
        }

        public String toString() {
            return "FormatterFactoryConfiguration.FormatterFactoryConfigurationBuilder(elasticSearchVersion$value=" + this.elasticSearchVersion$value + ", rules$key=" + this.rules$key + ", rules$value=" + this.rules$value + ")";
        }
    }
}

