/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.reporter.common.formatter.csv;

import io.gravitee.reporter.api.Reportable;
import io.gravitee.reporter.api.health.EndpointStatus;
import io.gravitee.reporter.api.http.Metrics;
import io.gravitee.reporter.api.log.Log;
import io.gravitee.reporter.api.monitor.Monitor;
import io.gravitee.reporter.api.v4.log.MessageLog;
import io.gravitee.reporter.api.v4.metric.MessageMetrics;
import io.gravitee.reporter.common.formatter.AbstractFormatter;
import io.gravitee.reporter.common.formatter.csv.EndpointStatusFormatter;
import io.gravitee.reporter.common.formatter.csv.MetricsFormatter;
import io.gravitee.reporter.common.formatter.csv.MonitorFormatter;
import io.gravitee.reporter.common.formatter.csv.v4.LogFormatter;
import io.gravitee.reporter.common.formatter.csv.v4.MessageLogFormatter;
import io.gravitee.reporter.common.formatter.csv.v4.MessageMetricsFormatter;
import io.vertx.core.buffer.Buffer;

public class CsvFormatter<T extends Reportable>
extends AbstractFormatter<T> {
    private static final EndpointStatusFormatter ENDPOINT_STATUS_FORMATTER = new EndpointStatusFormatter();
    private static final io.gravitee.reporter.common.formatter.csv.LogFormatter LOG_FORMATTER = new io.gravitee.reporter.common.formatter.csv.LogFormatter();
    private static final MetricsFormatter METRICS_FORMATTER = new MetricsFormatter();
    private static final MonitorFormatter MONITOR_FORMATTER = new MonitorFormatter();
    private static final LogFormatter LOG_V4_FORMATTER = new LogFormatter();
    private static final MessageLogFormatter MESSAGE_LOG_FORMATTER = new MessageLogFormatter();
    private static final io.gravitee.reporter.common.formatter.csv.v4.MetricsFormatter METRICS_V4_FORMATTER = new io.gravitee.reporter.common.formatter.csv.v4.MetricsFormatter();
    private static final MessageMetricsFormatter MESSAGE_METRICS_FORMATTER = new MessageMetricsFormatter();

    @Override
    public Buffer format0(T reportable) {
        if (reportable instanceof Metrics) {
            Metrics metrics = (Metrics)reportable;
            return METRICS_FORMATTER.format(metrics);
        }
        if (reportable instanceof Log) {
            Log log = (Log)reportable;
            return LOG_FORMATTER.format(log);
        }
        if (reportable instanceof EndpointStatus) {
            EndpointStatus endpointStatus = (EndpointStatus)reportable;
            return ENDPOINT_STATUS_FORMATTER.format(endpointStatus);
        }
        if (reportable instanceof Monitor) {
            Monitor monitor = (Monitor)reportable;
            return MONITOR_FORMATTER.format(monitor);
        }
        if (reportable instanceof io.gravitee.reporter.api.v4.metric.Metrics) {
            io.gravitee.reporter.api.v4.metric.Metrics metrics = (io.gravitee.reporter.api.v4.metric.Metrics)reportable;
            return METRICS_V4_FORMATTER.format(metrics);
        }
        if (reportable instanceof MessageMetrics) {
            MessageMetrics metrics = (MessageMetrics)reportable;
            return MESSAGE_METRICS_FORMATTER.format(metrics);
        }
        if (reportable instanceof io.gravitee.reporter.api.v4.log.Log) {
            io.gravitee.reporter.api.v4.log.Log log = (io.gravitee.reporter.api.v4.log.Log)reportable;
            return LOG_V4_FORMATTER.format(log);
        }
        if (reportable instanceof MessageLog) {
            MessageLog log = (MessageLog)reportable;
            return MESSAGE_LOG_FORMATTER.format(log);
        }
        return null;
    }
}

