/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.reporter.common.formatter.csv;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.reporter.api.health.EndpointStatus;
import io.gravitee.reporter.api.health.Step;
import io.gravitee.reporter.common.formatter.csv.SingleValueFormatter;
import io.vertx.core.buffer.Buffer;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndpointStatusFormatter
extends SingleValueFormatter<EndpointStatus> {
    private static final Logger LOG = LoggerFactory.getLogger(EndpointStatusFormatter.class);
    private final ObjectMapper mapper = new ObjectMapper();

    public EndpointStatusFormatter() {
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    @Override
    public Buffer format0(EndpointStatus status) {
        Buffer buffer = Buffer.buffer();
        this.appendString(buffer, status.getId());
        this.appendString(buffer, status.getApi());
        this.appendString(buffer, status.getEndpoint());
        this.appendInt(buffer, status.getState());
        this.appendBoolean(buffer, status.isAvailable());
        this.appendBoolean(buffer, status.isSuccess());
        this.appendBoolean(buffer, status.isTransition());
        this.appendLong(buffer, status.getResponseTime());
        this.append(buffer, status.getSteps());
        return buffer;
    }

    private void append(Buffer buffer, List<Step> steps) {
        if (steps != null && !steps.isEmpty()) {
            Step last = steps.get(0);
            this.appendString(buffer, last.getName());
            this.appendBoolean(buffer, last.isSuccess());
            this.appendLong(buffer, last.getResponseTime());
            this.appendString(buffer, last.getMessage(), true);
            try {
                this.appendString(buffer, this.mapper.writeValueAsString((Object)last.getRequest()));
            }
            catch (JsonProcessingException e) {
                LOG.error("Unexpected error while writing request as JSON", (Throwable)e);
            }
            try {
                this.appendString(buffer, this.mapper.writeValueAsString((Object)last.getResponse()));
            }
            catch (JsonProcessingException e) {
                LOG.error("Unexpected error while writing response as JSON", (Throwable)e);
            }
        } else {
            this.appendEmpty(buffer);
            this.appendEmpty(buffer);
            this.appendEmpty(buffer);
            this.appendEmpty(buffer);
            this.appendEmpty(buffer);
            this.appendEmpty(buffer);
        }
    }
}

